<?php if ('layout_four' == $settings['layout_type']) : ?>
    <!-- Propartes area start -->
    <div class="propartes-area pd-top-118 pd-bottom-90">
        <div class="container">
            <?php if ('yes' == $settings['heading_status']) : ?>
                <div class="section-title text-center">
                    <?php if (!empty($settings['sub_title'])) : ?>
                        <h6><?php echo esc_html($settings['sub_title']); ?></h6>
                    <?php endif; ?>
                    <?php if (!empty($settings['title'])) : ?>
                        <h2><?php echo wp_kses($settings['title'], 'swiftcart_core_allowed_tags');  ?></h2>
                    <?php endif; ?>
                </div>
            <?php endif; ?>

            <div class="mgd-tab-inner style-2 text-center">
                <ul class="nav nav-tabs" id="myTab" role="tablist">

                    <?php if (is_array($settings['select_tags'])) :
                        $i = 1;
                        foreach ($settings['select_tags'] as $index => $term) :
                            $active_class = $index == 0 ? "active" : '';
                    ?>
                            <?php
                            $property_post_two_query_paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

                            $args = array(
                                'post_type'      => 'property',
                                'post_status'    => 'publish',
                                'posts_per_page' =>  $settings['post_count']['size'],
                                'tax_query'      => array(
                                    array(
                                        'taxonomy' => 'property_status',
                                        'field'    => 'term_id',
                                        'terms'    => $term,
                                        'operator' => 'IN',
                                    ),
                                ),
                            );
                            if (!empty($settings['select_tags'])) {
                                $args['tax_query'][] = array(
                                    'taxonomy' => 'property_tag',
                                    'field'    => 'slug',
                                    'terms'    => array_values($settings['select_tags'])
                                );
                            }
                            $args['orderby'] = $settings['orderby'];
                            $args['order']   = $settings['order'];

                            if (!empty($settings['exclude_cat'])) {
                                $args['category__not_in'] = $settings['exclude_cat'];
                            }

                            $query = new \WP_Query($args);

                            ?>
                            <li class="nav-item">
                                <button class="nav-link <?php echo esc_attr($active_class) ?>" id="rent<?php echo esc_attr($index) ?>-tab" data-bs-toggle="tab" data-bs-target="#rent<?php echo esc_attr($index) ?>" type="button" role="tab" aria-controls="rent<?php echo esc_attr($index) ?>" aria-selected="true"><?php echo esc_html(swiftcart_core_property_tags($term)); ?></button>
                            </li>
                    <?php endforeach;
                    endif; ?>
                </ul>
            </div>
            <div class="tab-content" id="myTabContent">
                <?php
                $i = 1;
                if (is_array($settings['select_tags'])) :

                    foreach ($settings['select_tags'] as $index => $term) :
                        $active_class = $index == 0 ? "active show" : '';
                ?>
                        <div class="tab-pane fade <?php echo esc_attr($active_class) ?>" id="rent<?php echo esc_attr($index) ?>" role="tabpanel" aria-labelledby="rent<?php echo esc_attr($index) ?>-tab">
                            <div class="row">
                                <?php $args = array(
                                    'post_type'      => 'property',
                                    'post_status'    => 'publish',
                                    'posts_per_page' =>  $settings['post_count']['size'],
                                    'tax_query'      => array(
                                        array(
                                            'taxonomy' => 'property_tag',
                                            'field'    => 'term_id',
                                            'terms'    => $term,
                                            'operator' => 'IN',
                                        ),
                                    ),
                                );

                                $args['orderby'] = $settings['orderby'];
                                $args['order']   = $settings['order'];

                                $property_query = new \WP_Query($args);

                                if ($property_query->have_posts()) :
                                    while ($property_query->have_posts()) :
                                        $property_query->the_post();

                                        $property = get_post_meta(get_the_ID(), 'swiftcart_property_meta', true);
                                        $property_category =  get_the_terms(get_the_ID(), 'property_category');
                                        $property_item_status = get_the_terms(get_the_ID(), 'property_status');
                                ?>
                                        <div class="col-lg-4 col-md-6">
                                            <div class="single-product-wrap style-3">
                                                <div class="thumb">
                                                    <?php the_post_thumbnail('swiftcart_property_397X279'); ?>
                                                </div>
                                                <div class="product-details-inner">
                                                    <div class="row">
                                                        <div class="col-6">
                                                            <?php if (!empty($property['property_price'])) : ?>
                                                                <h4><?php echo esc_html($property['property_price']) ?></h4>
                                                            <?php else : ?>
                                                                <h4><?php echo esc_html_e("Price Not Set", 'swiftcart') ?></h4>
                                                            <?php endif; ?>
                                                        </div>
                                                        <div class="col-6 text-right">
                                                            <div class="meta-inner">
                                                                <?php foreach ($property_item_status as $item) : ?>
                                                                    <a class="btn btn-base btn-sm" href="<?php echo esc_url(get_tag_link($item->term_id)); ?>"><?php echo esc_html($item->name) ?></a>
                                                                <?php endforeach; ?>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row">
                                                        <div class="col-10">
                                                            <?php $blog_title = get_the_title();
                                                            $blog_title_count = substr($blog_title, 0, $settings['post_title_count']['size']); ?>
                                                            <p><a href="<?php the_permalink() ?>">
                                                                    <?php echo $blog_title_count; ?>
                                                                </a>
                                                            </p>
                                                        </div>
                                                        <div class="col-2 align-self-center">
                                                            <a class="wishlist" href="#"><i class="far fa-heart" aria-hidden="true"></i></a>
                                                        </div>
                                                    </div>
                                                    <?php if (!empty($property['property_area'])) : ?>
                                                        <ul class="meta-inner">
                                                            <li><img src="<?php echo get_theme_file_uri() ?>/assets/img/icon/location2.png" alt="img"><?php echo esc_html($property['property_area']); ?></li>
                                                            <li>
                                                        </ul>
                                                    <?php endif; ?>
                                                </div>
                                                <div class="product-meta-bottom style-2">

                                                    <?php if (!empty($property['property_bedrooms'])) : ?>
                                                        <span><?php echo esc_html($property['property_bedrooms']); ?><span><?php esc_html_e(' Bedroom', 'swiftcart-core') ?></span></span>
                                                    <?php endif; ?>


                                                    <?php if (!empty($property['property_bathrooms'])) : ?>
                                                        <span class="border-none"><?php echo esc_html($property['property_bathrooms']); ?><span><?php esc_html_e(' Bathroom', 'swiftcart-core') ?></span></span>
                                                    <?php endif; ?>

                                                    <?php if (!empty($property['property_area'])) : ?>
                                                        <span><?php echo esc_html($property['property_area']); ?></span>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                <?php endwhile;
                                endif; ?>
                            </div>
                        </div>
                <?php endforeach;
                endif; ?>
            </div>
        </div>
    </div>
    <!-- Propartes area end -->
<?php endif; ?>