<?php if ('layout_one' == $settings['layout_type']) : ?>
    <!-- product area start -->
    <div class="product-area pd-top-118 pd-bottom-90">
        <div class="container">
            <?php if ('yes' == $settings['heading_status']) : ?>
                <div class="section-title text-center">
                    <?php if (!empty($settings['sub_title'])) : ?>
                        <h6><?php echo esc_html($settings['sub_title']); ?></h6>
                    <?php endif; ?>
                    <?php if (!empty($settings['title'])) : ?>
                        <h2><?php echo wp_kses($settings['title'], 'swiftcart_core_allowed_tags');  ?></h2>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
            <div class="row justify-content-center">
                <?php
                $property_post_one_query_paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

                $args  = array(
                    'post_type'           => 'property',
                    'post_status'         => 'publish',
                    'ignore_sticky_posts' => 1,
                    'posts_per_page'      => $settings['post_count']['size'],
                    'paged' => $property_post_one_query_paged
                );

                $args['orderby'] = $settings['orderby'];
                $args['order']   = $settings['order'];
                if (!empty($settings['exclude_cat'])) {
                    $args['category__not_in'] = $settings['exclude_cat'];
                }


                if (!empty($settings['select_cat'])) {
                    $args['tax_query'][] = array(
                        'taxonomy' => 'property_cat',
                        'field'    => 'slug',
                        'terms'    => array_values($settings['select_cat'])
                    );
                }

                if (!empty($settings['select_tag'])) {
                    $args['tax_query'][] = array(
                        'taxonomy' => 'property_status',
                        'field'    => 'slug',
                        'terms'    => array_values($settings['select_tag'])
                    );
                }

                $property_query = new \WP_Query($args);
                ?>
                <?php while ($property_query->have_posts()) :

                    $property_query->the_post();
                    $property = get_post_meta(get_the_ID(), 'swiftcart_property_meta', true);
                    $property_category =  get_the_terms(get_the_ID(), 'property_category');
                    $property_item_status = get_the_terms(get_the_ID(), 'property_status');


                ?>
                    <div class="col-lg-4 col-md-6">
                        <div class="single-product-wrap">
                            <div class="thumb">
                                <?php the_post_thumbnail('swiftcart_property_397X433'); ?>
                                <?php $property_status = get_the_terms($post->ID, 'property_status'); ?>
                                <?php if (!empty($property_status[0]->name)) : ?>
                                    <a class="cat" href="<?php echo esc_url(get_tag_link($property_status[0]->term_id)); ?>"><?php echo esc_html($property_status[0]->name); ?></a>
                                <?php endif; ?>
                            </div>
                            <div class="product-wrap-details">
                                <div class="media">
                                    <div class="author">
                                        <?php
                                        $author_id = get_the_author_meta('ID');
                                        $avatar_url = get_avatar_url($author_id);
                                        ?>
                                        <img src="<?php echo esc_url($avatar_url) ?>" alt="<?php esc_html_e("author", 'swiftcart') ?>">
                                    </div>
                                    <div class="media-body">
                                        <h6><a href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>">
                                                <?php the_author(); ?>
                                            </a></h6>
                                        <p>
                                            <img src="<?php echo get_theme_file_uri() ?>/assets/img/icon/location-alt.png" alt="img">

                                            <?php if (!empty($property['property_location_name'])) :
                                                esc_html_e($property['property_location_name'], 'swiftcart');
                                            else :
                                                esc_html_e("Not Set", 'swiftcart');
                                            endif ?>
                                        </p>
                                    </div>
                                    <a class="fav-btn float-right" href="#"><i class="far fa-heart" aria-hidden="true"></i></a>
                                </div>
                                <div class="product-meta">
                                    <?php if (!empty($property['property_price'])) : ?>
                                        <span class="price"><?php echo esc_html($property['property_price']) ?></span>
                                    <?php else : ?>
                                        <span class="price"><?php echo esc_html_e("Price Not Set", 'swiftcart') ?></span>
                                    <?php endif; ?>
                                    <div class="float-right d-inline-block">
                                        <ul>
                                            <?php if (!empty($property['property_bathrooms'])) : ?>
                                                <li>
                                                    <img src="<?php echo get_theme_file_uri() ?>/assets/img/icon/triangle.png" alt="img">
                                                    <?php echo esc_html($property['property_bathrooms']); ?>
                                                </li>
                                            <?php endif; ?>
                                            <?php if (!empty($property['property_bedrooms'])) : ?>
                                                <li>
                                                    <img src="<?php echo get_theme_file_uri() ?>/assets/img/icon/bed.png" alt="img">
                                                    <?php echo esc_html($property['property_bedrooms']); ?>
                                                </li>
                                            <?php endif; ?>
                                            <?php if (!empty($property['property_area'])) : ?>
                                                <li><img src="<?php echo get_theme_file_uri() ?>/assets/img/icon/wall.png" alt="img"><?php echo esc_html($property['property_area']); ?></li>
                                            <?php endif; ?>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endwhile; ?>
                <?php wp_reset_postdata(); ?>
            </div>
        </div>
    </div>
    <!-- product area end -->


<?php endif; ?>