<?php if ('layout_seven' == $settings['layout_type']) : ?>
    <!-- blog-page- Start -->
    <div class="blog-page-area pt-120 pb-120 body-bg">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-12">
                    <div class="product-search-inner bg-main">
                        <div class="row custom-gutters-20">
                            <div class="col-md-3 align-self-center">
                                <h5>21 Properties</h5>
                            </div>
                            <div class="col-md-6 mt-2 mt-md-0">
                                <div class="widget-search">
                                    <div class="single-search-inner">
                                        <input type="text" placeholder="Search your keyword">
                                        <button><i class="la la-search"></i></button>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3 mt-2 mt-md-0 align-self-center">
                                <div class="single-select-inner">
                                    <select>
                                        <option value="1">Sort By</option>
                                        <option value="2">Sort By</option>
                                        <option value="3">Sort By</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php
                $property_post_one_query_paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

                $args  = array(
                    'post_type'           => 'property',
                    'post_status'         => 'publish',
                    'ignore_sticky_posts' => 1,
                    'posts_per_page'      => $settings['post_count']['size'],
                    'paged' => $property_post_one_query_paged
                );

                $args['orderby'] = $settings['orderby'];
                $args['order']   = $settings['order'];
                if (!empty($settings['exclude_cat'])) {
                    $args['category__not_in'] = $settings['exclude_cat'];
                }


                if (!empty($settings['select_cat'])) {
                    $args['tax_query'][] = array(
                        'taxonomy' => 'property_status',
                        'field'    => 'slug',
                        'terms'    => array_values($settings['select_cat'])
                    );
                }

                if (!empty($settings['select_tag'])) {
                    $args['tax_query'][] = array(
                        'taxonomy' => 'property_cat',
                        'field'    => 'slug',
                        'terms'    => array_values($settings['select_tag'])
                    );
                }

                $property_query = new \WP_Query($args);
                ?>
                <?php while ($property_query->have_posts()) :
                    $property_query->the_post();

                    $property = get_post_meta(get_the_ID(), 'swiftcart_property_meta', true);
                    $property_category =  get_the_terms(get_the_ID(), 'property_category');
                    $property_item_status = get_the_terms(get_the_ID(), 'property_status');


                ?>
                    <div class="col-lg-4 col-md-6">
                        <div class="single-product-wrap style-2">
                            <div class="thumb">
                                <a href="<?php the_permalink() ?>">
                                    <?php the_post_thumbnail('swiftcart_property_397X433'); ?>
                                </a>
                                <div class="product-wrap-details">
                                    <div class="media">
                                        <div class="author">
                                            <?php
                                            $author_id = get_the_author_meta('ID');
                                            $avatar_url = get_avatar_url($author_id);
                                            ?>
                                            <img src="<?php echo esc_url($avatar_url) ?>" alt="<?php esc_html_e("author", 'swiftcart') ?>">
                                        </div>

                                        <div class="media-body">
                                            <h6><a href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>"><?php the_author(); ?></a></h6>

                                            <p>
                                                <img src="<?php echo get_theme_file_uri() ?>/assets/img/icon/location-alt.png" alt="img">
                                                <?php if (!empty($property['property_location_name'])) :
                                                    esc_html_e($property['property_location_name'], 'swiftcart');
                                                else :
                                                    esc_html_e("Not Set", 'swiftcart');
                                                endif ?>
                                            </p>
                                        </div>
                                        <a class="fav-btn float-right" href="#"><i class="far fa-heart"></i></a>
                                    </div>
                                </div>
                            </div>
                            <div class="product-details-inner">
                                <?php $blog_title = get_the_title();
                                $blog_title_count = substr($blog_title, 0, $settings['post_title_count']['size']); ?>
                                <h4><a href="<?php the_permalink() ?>">
                                        <?php echo  $blog_title_count; ?>
                                    </a>
                                </h4>
                                <ul class="meta-inner">
                                    <li>
                                        <img src="<?php echo get_theme_file_uri() ?>/assets/img/icon/location2.png" alt="img">
                                        <?php if (!empty($property['property_location_name'])) :
                                            esc_html_e($property['property_location_name'], 'swiftcart');
                                        else :
                                            esc_html_e("Not Set", 'swiftcart');
                                        endif ?>
                                    </li>
                                    <?php if (!empty($property_item_status[0]->name)) : ?>
                                        <li><a href="<?php echo esc_url(get_term_link($property_item_status[0]->term_id)); ?>"><?php echo esc_html($property_item_status[0]->name); ?></a></li>
                                    <?php endif; ?>
                                </ul>
                                <?php if (!empty($property['property_short_info'])) : ?>
                                    <p><?php echo wp_trim_words($property['property_short_info'], $settings['word_limit']['size']); ?></p>
                                <?php endif; ?>
                                <?php if (!empty($property['property_price'])) : ?>
                                    <span class="price"><?php echo esc_html($property['property_price']) ?></span>
                                <?php else : ?>
                                    <span class="price"><?php echo esc_html_e("Price Not Set", 'swiftcart') ?></span>
                                <?php endif; ?>
                            </div>
                            <div class="product-meta-bottom style-2">
                                <?php if (!empty($property['property_bedrooms'])) : ?>
                                    <span><?php echo esc_html($property['property_bedrooms']); ?><span><?php esc_html_e(' Bedroom', 'swiftcart-core') ?></span></span>
                                <?php endif; ?>
                                <?php if (!empty($property['property_bathrooms'])) : ?>
                                    <span class="border-none"><?php echo esc_html($property['property_bathrooms']); ?><span><?php esc_html_e(' Bathroom', 'swiftcart-core') ?></span></span>
                                <?php endif; ?>

                                <?php if (!empty($property['property_area'])) : ?>
                                    <span><?php echo esc_html($property['property_area']); ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endwhile; ?>
                <?php wp_reset_postdata(); ?>
            </div>
            <?php if ('yes' == $settings['pagination_status']) : ?>
                <div class="pagination wp-pagination pt-20">
                    <?php swiftcart_custom_query_pagination($property_post_one_query_paged, $property_query->max_num_pages); ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
    <!-- blog-page- end -->
<?php endif; ?>