<?php if ('layout_three' == $settings['layout_type']) : ?>
    <!-- Propartes area start -->
    <div class="propartes-area pd-top-118 pd-bottom-90">
        <div class="container">
            <?php if ('yes' == $settings['heading_status']) : ?>
                <div class="section-title text-center">
                    <?php if (!empty($settings['sub_title'])) : ?>
                        <h6><?php echo esc_html($settings['sub_title']); ?></h6>
                    <?php endif; ?>
                    <?php if (!empty($settings['title'])) : ?>
                        <h2><?php echo wp_kses($settings['title'], 'swiftcart_core_allowed_tags');  ?></h2>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
            <div class="mgd-tab-inner text-center">
                <ul class="nav nav-tabs" id="myTab" role="tablist">
                    <?php if (is_array($settings['select_cat'])) :
                        $i = 1;
                        foreach ($settings['select_cat'] as $index => $term) :
                            $active_class = $index == 0 ? "active" : '';
                    ?>
                            <?php
                            $property_post_two_query_paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

                            $args = array(
                                'post_type'      => 'property',
                                'post_status'    => 'publish',
                                'posts_per_page' =>  $settings['post_count']['size'],
                                'tax_query'      => array(
                                    array(
                                        'taxonomy' => 'property_status',
                                        'field'    => 'term_id',
                                        'terms'    => $term,
                                        'operator' => 'IN',
                                    ),
                                ),
                            );
                            if (!empty($settings['select_tag'])) {
                                $args['tax_query'][] = array(
                                    'taxonomy' => 'property_cat',
                                    'field'    => 'slug',
                                    'terms'    => array_values($settings['select_tag'])
                                );
                            }
                            $args['orderby'] = $settings['orderby'];
                            $args['order']   = $settings['order'];

                            if (!empty($settings['exclude_cat'])) {
                                $args['category__not_in'] = $settings['exclude_cat'];
                            }

                            $query = new \WP_Query($args);

                            ?>
                            <li class="nav-item">
                                <button class="nav-link <?php echo esc_attr($active_class) ?>" id="rent<?php echo esc_attr($index) ?>-tab" data-bs-toggle="tab" data-bs-target="#rent<?php echo esc_attr($index) ?>" type="button" role="tab" aria-controls="rent<?php echo esc_attr($index) ?>" aria-selected="true"><?php echo esc_html(swiftcart_core_property_cat($term)); ?></button>
                            </li>
                    <?php endforeach;
                    endif; ?>
                </ul>
            </div>
            <div class="tab-content" id="myTabContent">
                <?php
                $i = 1;
                if (is_array($settings['select_cat'])) :

                    foreach ($settings['select_cat'] as $index => $term) :
                        $active_class = $index == 0 ? "active show" : '';
                ?>


                        <div class="tab-pane fade <?php echo esc_attr($active_class) ?>" id="rent<?php echo esc_attr($index) ?>" role="tabpanel" aria-labelledby="rent<?php echo esc_attr($index) ?>-tab">

                            <div class="row">
                                <?php $args = array(
                                    'post_type'      => 'property',
                                    'post_status'    => 'publish',
                                    'posts_per_page' =>  $settings['post_count']['size'],
                                    'tax_query'      => array(
                                        array(
                                            'taxonomy' => 'property_status',
                                            'field'    => 'term_id',
                                            'terms'    => $term,
                                            'operator' => 'IN',
                                        ),
                                    ),
                                );

                                $args['orderby'] = $settings['orderby'];
                                $args['order']   = $settings['order'];

                                $query = new \WP_Query($args);

                                if ($query->have_posts()) :
                                    while ($query->have_posts()) :
                                        $query->the_post();

                                        $property = get_post_meta(get_the_ID(), 'swiftcart_property_meta', true);
                                        $property_category =  get_the_terms(get_the_ID(), 'property_category');
                                        $property_item_status = get_the_terms(get_the_ID(), 'property_status');
                                ?>
                                        <div class="col-lg-4 col-md-6">
                                            <div class="single-product-wrap style-bottom">
                                                <div class="thumb">
                                                    <?php the_post_thumbnail('swiftcart_property_397X279'); ?>
                                                    <div class="product-wrap-details">
                                                        <div class="media">
                                                            <div class="author">
                                                                <?php
                                                                $author_id = get_the_author_meta('ID');
                                                                $avatar_url = get_avatar_url($author_id);
                                                                ?>
                                                                <img src="<?php echo esc_url($avatar_url) ?>" alt="<?php esc_html_e("author", 'swiftcart') ?>">
                                                            </div>
                                                            <div class="media-body">
                                                                <h6>
                                                                    <a href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>">
                                                                        <?php the_author(); ?>
                                                                    </a>
                                                                </h6>

                                                                <p><img src="<?php echo get_theme_file_uri() ?>/assets/img/icon/location-alt.png" alt="img">
                                                                    <?php if (!empty($property['property_location_name'])) :
                                                                        esc_html_e($property['property_location_name'], 'swiftcart');
                                                                    else :
                                                                        esc_html_e("Not Set", 'swiftcart');
                                                                    endif ?> </p>
                                                            </div>
                                                            <a class="fav-btn float-right" href="#"><i class="far fa-heart" aria-hidden="true"></i></a>

                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="product-details-inner">
                                                    <?php $blog_title = get_the_title();
                                                    $blog_title_count = substr($blog_title, 0, $settings['post_title_count']['size']); ?>
                                                    <h4><a href="<?php the_permalink() ?>">
                                                            <?php echo  $blog_title_count; ?>
                                                        </a>
                                                    </h4>
                                                    <ul class="meta-inner">
                                                        <li>
                                                            <img src="<?php echo get_theme_file_uri() ?>/assets/img/icon/location2.png" alt="img">
                                                            <?php if (!empty($property['property_location_name'])) :
                                                                esc_html_e($property['property_location_name'], 'swiftcart');
                                                            else :
                                                                esc_html_e("Not Set", 'swiftcart');
                                                            endif ?>
                                                        </li>
                                                        <li>
                                                            <?php $property_status = get_the_terms($post->ID, 'property_status'); ?>
                                                            <?php if (!empty($property_status[0]->name)) : ?>
                                                                <a href="<?php echo esc_url(get_tag_link($property_status[0]->term_id)); ?>"><?php echo esc_html($property_status[0]->name); ?></a>
                                                            <?php endif; ?>
                                                        </li>
                                                    </ul>

                                                    <?php if (!empty($property['property_short_info'])) : ?>
                                                        <p><?php echo wp_trim_words($property['property_short_info'], $settings['word_limit']['size']); ?></p>
                                                    <?php endif; ?>
                                                </div>
                                                <div class="product-meta-bottom">

                                                    <?php if (!empty($property['property_price'])) : ?>
                                                        <span class="price"><?php echo esc_html($property['property_price']) ?></span>
                                                    <?php else : ?>
                                                        <span class="price"><?php echo esc_html_e("Price Not Set", 'swiftcart') ?></span>
                                                    <?php endif; ?>

                                                    <?php $property_status = get_the_terms($post->ID, 'property_status'); ?>
                                                    <?php if (!empty($property_status[0]->name)) : ?>
                                                        <span><?php echo esc_html($property_status[0]->name); ?></span>
                                                    <?php endif; ?>

                                                    <?php
                                                    $post_timestamp = get_post_time('U', false, get_the_ID());
                                                    // Get the human-readable difference
                                                    $time_difference = human_time_diff($post_timestamp, current_time('U'));; ?>
                                                    <span><?php esc_html_e($time_difference . " ago", 'swiftcart-core'); ?> </span>
                                                </div>
                                            </div>
                                        </div>
                                <?php endwhile;
                                endif; ?>
                            </div>
                        </div>
                <?php endforeach;
                endif ?>
            </div>
        </div>
    </div>
    <!-- Propartes area end -->
<?php endif; ?>