<?php if ('layout_two' == $settings['layout_type']) : ?>
    <!-- product area start -->
    <div class="product-area pd-top-118 pd-bottom-120">
        <div class="container">
            <?php if ('yes' == $settings['heading_status']) : ?>
                <div class="section-title text-center">
                    <?php if (!empty($settings['sub_title'])) : ?>
                        <h6><?php echo esc_html($settings['sub_title']); ?></h6>
                    <?php endif; ?>
                    <?php if (!empty($settings['title'])) : ?>
                        <h2><?php echo wp_kses($settings['title'], 'swiftcart_core_allowed_tags');  ?></h2>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
            <div class="row">
                <?php
                $property_post_one_query_paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

                $args  = array(
                    'post_type'           => 'property',
                    'post_status'         => 'publish',
                    'ignore_sticky_posts' => 1,
                    'posts_per_page'      => $settings['post_count']['size'],
                    'paged' => $property_post_one_query_paged
                );

                $args['orderby'] = $settings['orderby'];
                $args['order']   = $settings['order'];
                if (!empty($settings['exclude_cat'])) {
                    $args['category__not_in'] = $settings['exclude_cat'];
                }


                if (!empty($settings['select_cat'])) {
                    $args['tax_query'][] = array(
                        'taxonomy' => 'property_status',
                        'field'    => 'slug',
                        'terms'    => array_values($settings['select_cat'])
                    );
                }

                if (!empty($settings['select_tag'])) {
                    $args['tax_query'][] = array(
                        'taxonomy' => 'property_cat',
                        'field'    => 'slug',
                        'terms'    => array_values($settings['select_tag'])
                    );
                }

                $property_query = new \WP_Query($args);
                ?>
                <?php while ($property_query->have_posts()) :
                    $property_query->the_post();


                    $property = get_post_meta(get_the_ID(), 'swiftcart_property_meta', true);
                    $property_category =  get_the_terms(get_the_ID(), 'property_category');
                    $property_item_status = get_the_terms(get_the_ID(), 'property_status');


                ?>
                    <div class="col-lg-4 col-md-6">
                        <div class="single-product-wrap">
                            <div class="thumb">
                                <?php the_post_thumbnail('swiftcart_property_397X279'); ?>
                                <div class="btn-area">
                                    <?php $property_status = get_the_terms($post->ID, 'property_status'); ?>
                                    <?php if (!empty($property_status[0]->name)) : ?>
                                        <a class="btn btn-base btn-sm" href="<?php echo esc_url(get_tag_link($property_status[0]->term_id)); ?>"><?php echo esc_html($property_status[0]->name); ?></a>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="product-wrap-details">
                                <div class="media">
                                    <div class="media-body">
                                        <?php if (!empty($property['property_price'])) : ?>
                                            <h5><a href="<?php the_permalink() ?>"><?php echo esc_html($property['property_price']) ?></a></h5>
                                        <?php else : ?>
                                            <h5><a href="<?php the_permalink() ?>"><?php echo esc_html_e("Price Not Set", 'swiftcart') ?></a></h5>
                                        <?php endif; ?>
                                        <?php if (!empty($property['property_short_info'])) : ?>
                                            <p><?php echo wp_trim_words($property['property_short_info'], $settings['word_limit']['size']); ?></p>
                                        <?php endif; ?>
                                    </div>
                                    <a class="fav-btn float-right" href="#"><i class="far fa-heart" aria-hidden="true"></i></a>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endwhile; ?>
                <?php wp_reset_postdata(); ?>
                <?php if (!empty($settings['button_label'])) : ?>
                    <div class="col-12">
                        <div class="btn-wrap text-center mt-4">
                            <a class="btn btn-base" <?php esc_attr(!empty($settings['button_url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($settings['button_url']['url']); ?>"><?php echo esc_html($settings['button_label']); ?></a>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <!-- product area end -->
<?php endif; ?>