<?php if ('layout_two' == $settings['layout_type']) : ?>
    <!--======  Start Video Section  ======-->
    <section class="video-section">
        <div class="video-bg-wrapper pt-110 pb-90">
            <div class="shape shape-one"><span><?php swiftcart_elementor_rendered_image($settings, 'layout_two_shape_one'); ?></span></div>
            <div class="shape shape-two"><span><?php swiftcart_elementor_rendered_image($settings, 'layout_two_shape_two'); ?></span></div>
            <div class="shape shape-three"><span><?php swiftcart_elementor_rendered_image($settings, 'layout_two_shape_three'); ?></span></div>
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-lg-8">
                        <!--===  Section Title  ===-->
                        <div class="section-title text-center mb-55 wow fadeInDown">
                            <span class="sub-title"><?php swiftcart_elementor_rendered_image($settings, 'layout_two_subtitle_shape'); ?> <?php echo wp_kses($settings['layout_two_sec_sub_title'], 'swiftcart_core_allowed_tags');  ?> <?php swiftcart_elementor_rendered_image($settings, 'layout_two_subtitle_shape'); ?></span>
                            <?php

                            if (!empty($settings['layout_two_sec_title'])) :
                                $this->add_inline_editing_attributes('layout_two_sec_title', 'none');
                                swiftcart_elementor_rendered_content($this, 'layout_two_sec_title', '', $settings['section_title_tag_layout_two']);
                            endif;

                            if (!empty($settings['layout_two_sec_summary'])) :
                                $this->add_inline_editing_attributes('layout_two_sec_summary', 'none');
                                swiftcart_elementor_rendered_content($this, 'layout_two_sec_summary', '', 'p');
                            endif;
                            ?>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <?php
                    $i = 1;
                    foreach ($settings['layout_two_service_list'] as $index => $item) :
                    ?>
                        <div class="col-xl-4 col-md-6 col-sm-12">
                            <!--===  Features Image Card  ===-->
                            <div class="features-image-card mb-30 wow fadeInUp">
                                <div class="image">
                                    <?php swiftcart_elementor_rendered_image($item, 'image'); ?>
                                </div>
                                <div class="content">
                                    <h4><a <?php esc_attr(!empty($item['url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($item['url']['url']); ?>"><?php echo wp_kses($item['title'], 'swiftcart_core_allowed_tags'); ?></a>
                                    </h4>
                                    <p><?php echo wp_kses($item['summary'], 'swiftcart_core_allowed_tags'); ?></p>

                                    <a <?php esc_attr(!empty($item['url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($item['url']['url']); ?>" class="theme-btn style-two"><?php echo wp_kses($item['button_label'], 'swiftcart_core_allowed_tags'); ?></a>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </section><!--======  End Video Section  ======-->
<?php endif; ?>