<?php if ('layout_one' == $settings['layout_type']) : ?>
    <!--======  Start Skill Section  ======-->
    <section class="skill-section pb-70">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-xl-7">
                    <div class="skill-content-box wow fadeInLeft">
                        <div class="section-title mb-50">
                            <h2><?php echo wp_kses($settings['title'], 'swiftcart_core_allowed_tags');  ?></h2>
                            <p><?php echo wp_kses($settings['summary'], 'swiftcart_core_allowed_tags');  ?></p>
                        </div>
                        <?php if (is_array($settings['skill'])) : ?>
                            <?php $i = 3;
                            foreach ($settings['skill'] as $item) : ?>
                                <div class="skill-item style-one mb-50">
                                    <h5><span><?php echo esc_html($item['name']); ?></span> <span class="count"><?php echo esc_html($item['percentage']); ?>%</span></h5>
                                    <div class="progress">
                                        <div class="progress-bar skill-bar skill1 wow slideInLeft" role="progressbar" style="width: <?php echo esc_attr($item['percentage']); ?>%;" aria-valuenow="<?php echo esc_attr($item['percentage']); ?>" aria-valuemin="0" aria-valuemax="100"><?php echo esc_html($item['percentage']); ?></div>
                                    </div>
                                </div>

                            <?php endforeach; ?>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="col-xl-5">
                    <div class="skill-one_image-box mb-50 wow fadeInRight">
                        <div class="swiftcart-tilt" data-tilt-options='{ "glare": false, "maxGlare": 0, "maxTilt": 5, "speed": 700, "scale": 1 }'>
                            <?php swiftcart_elementor_rendered_image($settings, 'img_one'); ?>
                        </div>
                        <?php if (!empty($settings['video_url'])) : ?>
                            <div class="image-overlay">
                                <div class="play-button d-flex align-items-center">
                                    <a href="<?php echo esc_attr($settings['video_url']) ?>" class="video-popup"><i class="flaticon-play-button-arrowhead"></i></a>
                                    <div class="text"><?php echo wp_kses($settings['video_title'], 'swiftcart_core_allowed_tags');  ?></div>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </section><!--======  End Skill Section  ======-->


<?php endif; ?>