<?php if ('layout_three' == $settings['layout_type']) : ?>
    <!-- sw slider three start -->
    <div class="sw-slider-three p-relative">
        <div class="sw-slider-three__carousel swiftcart-owl__carousel owl-theme owl-carousel" data-owl-options='{
            "items": 1,
            "animateOut": "fadeOut",
		    "animateIn": "fadeIn",
            "margin": 0,
            "smartSpeed": 700,
            "loop":true,
            "autoplay": true,
            "nav":false,
            "URLhashListener":true,
            "dots":false,
            "navText": ["<span class=\"icon-arrow-left\"></span>","<span class=\"icon-arrow\"></span>"]
            }'>
            <?php foreach ($settings['slider_list_three'] as $index => $item) : ?>
                <div class="item" data-hash="item<?php echo esc_attr($index); ?>">
                    <div class="container">
                        <div class="row align-items-center">
                            <?php if (!empty($item['image']['url'])): ?>
                                <div class="col-lg-6">
                                    <div class="sw-slider-three__img">
                                        <?php swiftcart_elementor_rendered_image($item, 'image'); ?>
                                    </div>
                                </div>
                            <?php endif; ?>
                            <div class="col-lg-6">
                                <div class="sw-slider-three__content">
                                    <?php if (!empty($item['big_title'])): ?>
                                        <h4 class="sw-slider-three__bigtitle el-slider-summary"><?php echo wp_kses($item['big_title'], 'swiftcart_core_allowed_tags'); ?></h4>
                                    <?php endif; ?>
                                    <?php if (!empty($item['subtitle'])): ?>
                                        <span class="sw-slider-three__subtitle el-slider-subtitle"><?php echo wp_kses($item['subtitle'], 'slider_title_tag_layout_one') ?></span>
                                    <?php endif; ?>
                                    <?php if (!empty($item['title'])): ?>
                                        <<?php echo esc_attr($item['slider_title_tag_layout_three']); ?> class="sw-slider-three__title el-slider-title"><?php echo wp_kses($item['title'], 'swiftcart_core_allowed_tags'); ?></<?php echo esc_attr($item['slider_title_tag_layout_three']); ?>>
                                    <?php endif; ?>
                                    <?php if (!empty($item['button_label'])): ?>
                                        <a class="sw-slider-three__btn el-slider-btn" href="<?php echo esc_url($item['url']['url']); ?>"><?php echo esc_html($item['button_label']); ?>
                                        </a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
        <div class="sw-slider-three__carousel-thumb swiftcart-owl__carousel owl-theme owl-carousel" data-owl-options='{
        "items":4,
        "margin": 40,
        "smartSpeed": 700,
        "loop":true,
        "autoplay": true,
        "URLhashListener":true,
        "dots":false,
        "responsive": {
            "0": {
                "items": 3
            },
            "1200": {
                "items": 4
            }
        }
        }'>
            <?php foreach ($settings['slider_list_three'] as $index => $item) : ?>
                <a href="#item<?php echo esc_attr($index); ?>" class="item">
                    <span class="sw-slider-three__thumb">
                        <?php swiftcart_elementor_rendered_image($item, 'image'); ?>
                    </span>
                </a><!-- testimonial-author -->
            <?php endforeach; ?>
        </div>
    </div>
    <!-- sw slider three end -->
<?php endif; ?>