<?php if ('layout_two' == $settings['layout_type']) : ?>
    <!-- sw main slider two start -->
    <div class="sw-header-two-banner">
        <div class="sw-main-slider sw-main-slider-two">
            <div class="sw-main-slider__carousel swiftcart-owl__carousel owl-carousel" data-owl-options='{
                        "loop": true,
                        "animateOut": "fadeOut",
                        "animateIn": "fadeIn",
                        "items": 1,
                        "autoplay": true,
                        "autoplayTimeout": 7000,
                        "smartSpeed": 1000,
                        "nav": false,
                        "navText": ["<span class=\"fa-solid fa-chevron-left\"></span>","<span class=\"fa-solid fa-chevron-right\"></span>"],
                        "dots": true,
                        "margin": 0
                        }'>
                <?php foreach ($settings['slider_list_one'] as $index => $item) : ?>
                    <div class="sw-main-slider__item">
                        <div class="sw-main-slider__left">
                            <div class="sw-main-slider__content">
                                <?php if (!empty($item['subtitle'])): ?>
                                    <span class="sw-main-slider__subtitle el-slider-subtitle"><?php echo esc_html($item['subtitle']) ?></span>
                                <?php endif; ?>
                                <?php if (!empty($item['title'])): ?>
                                    <<?php echo esc_attr($item['slider_title_tag_layout_one']); ?> class="sw-main-slider__title el-slider-title"><?php echo wp_kses($item['title'], 'swiftcart_core_allowed_tags'); ?></<?php echo esc_attr($item['slider_title_tag_layout_one']); ?>>
                                <?php endif; ?>
                                <?php if (!empty($item['summary'])): ?>
                                    <p class="sw-main-slider__info el-slider-info"><?php echo wp_kses($item['summary'], 'swiftcart_core_allowed_tags'); ?></p>
                                <?php endif; ?>

                                <?php if (!empty($item['button_label'])): ?>
                                    <div class="sw-main-slider__btn">
                                        <a class="swiftcart-btn" href="<?php echo esc_url($item['url']['url']); ?>"><?php echo esc_html($item['button_label']); ?>
                                            <?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true'], 'i'); ?>
                                        </a>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php if (!empty($item['image']['url'])): ?>
                            <div class="sw-main-slider__right">
                                <div class="sw-main-slider__img">
                                    <?php swiftcart_elementor_rendered_image($item, 'image'); ?>
                                    <?php if (!empty($item['price'])): ?>
                                        <span class="sw-main-slider__price"><?php echo esc_html($item['price']); ?></span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
    <!-- sw main slider two end  -->
<?php endif; ?>