<?php if ('layout_one' == $settings['layout_type']) : ?>
    <!--======  Start Clients Section  ======-->
    <section class="clients-section">
        <div class="container">
            <?php if (!empty($settings['sponsor_title'])) : ?>
                <div class="row">
                    <div class="col-lg-12">
                        <!--=== Clients Text ===-->
                        <div class="clients-text style-one text-center mb-30 wow fadeInDown">
                            <p><?php echo wp_kses($settings['sponsor_title'], 'swiftcart_core_allowed_tags');  ?></p>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
            <!--=== Clients Slider Content ===-->
            <div class="clients-slider wow fadeInUp">
                <?php foreach ($settings['sponsor'] as $item) : ?>
                    <!--=== client item ===-->
                    <div class="client-item">
                        <div class="client-img swiftcart-tilt" data-tilt-options='{ "glare": false, "maxGlare": 0, "maxTilt": 15, "speed": 700, "scale": 1 }'>
                            <?php if (!empty($item['logo_url']['url'])) : ?>
                                <a href="<?php echo esc_url($item['logo_url']['url']); ?>"><img src="<?php echo esc_url($item['logo']['url']); ?>" alt="<?php echo esc_attr(swiftcart_core_get_thumbnail_alt($item['logo']['id'])); ?>"></a>
                            <?php else : ?>
                                <?php if (!empty($item['logo']['url'])) : ?>
                                    <img src="<?php echo esc_url($item['logo']['url']); ?>" alt="<?php echo esc_attr(swiftcart_core_get_thumbnail_alt($item['logo']['id'])); ?>">
                                <?php endif; ?>
                            <?php endif; ?>
                        </div>
                    </div>
                    <!--=== client item ===-->
                <?php endforeach; ?>
            </div>
        </div>
    </section><!--======  End Clients Section  ======-->
<?php endif; ?>