<?php if ('layout_one' == $settings['layout_type']) : ?>
    <!--======  Start Case Section  ======-->
    <section class="use-cases-section pt-110 pb-65">
        <div class="case-wrapper p-r z-1">
            <div class="shape shape-one"><span><?php swiftcart_elementor_rendered_image($settings, 'layout_one_shape'); ?></span></div>
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <!--===  Section Title  ===-->
                        <div class="section-title text-center mb-55 wow fadeInDown">
                            <?php if (!empty($settings['sec_sub_title'])) : ?>
                                <span class="sub-title"><?php swiftcart_elementor_rendered_image($settings, 'subtitle_shape'); ?><?php echo wp_kses($settings['sec_sub_title'], 'swiftcart_core_allowed_tags');  ?><?php swiftcart_elementor_rendered_image($settings, 'subtitle_shape'); ?></span>
                            <?php endif; ?>
                            <?php if (!empty($settings['sec_title'])) : ?>
                                <h2><?php echo wp_kses($settings['sec_title'], 'swiftcart_core_allowed_tags');  ?></h2>
                            <?php endif; ?>
                            <?php if (!empty($settings['sec_summary'])) : ?>
                                <p><?php echo wp_kses($settings['sec_summary'], 'swiftcart_core_allowed_tags');  ?></p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12">
                        <!--===  Themes Tabs  ===-->
                        <div class="theme-tabs style-one mb-45 wow fadeInUp">
                            <ul class="nav nav-tabs justify-content-center">
                                <?php foreach ($settings['layout_one_projects_filter'] as $index => $item) :
                                    $active = ($index == 0) ? 'active' : '';
                                ?>
                                    <li>
                                        <button class="nav-link <?php echo esc_attr($active); ?>" data-bs-toggle="tab" data-bs-target="#case<?php echo esc_attr($index + 1) ?>"><?php echo esc_html($item['name']); ?></button>
                                    </li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12">
                        <!--===  Tab Content  ===-->
                        <div class="tab-content wow fadeInDown">
                            <?php foreach ($settings['tab_list_one'] as $index => $item) : $active = ($index == 0) ? 'active show' : ''; ?>
                                <!--===  Tab Pane  ===-->
                                <div class="tab-pane fade <?php echo esc_attr($active); ?>" id="case<?php echo esc_attr($index + 1) ?>">
                                    <div class="row">
                                        <div class="col-lg-5">
                                            <!--===  Section Content Box  ===-->
                                            <div class="ac-tab-one_content-box mb-50">
                                                <h5><?php echo wp_kses($item['title'], 'swiftcart_core_allowed_tags');  ?></h5>
                                                <p><?php echo wp_kses($item['info'], 'swiftcart_core_allowed_tags');  ?></p>
                                                <div class="author-thumb-item mb-55">
                                                    <div class="thumb">
                                                        <?php swiftcart_elementor_rendered_image($item, 'avata'); ?>
                                                    </div>
                                                    <div class="content">
                                                        <h6><?php echo wp_kses($item['name'], 'swiftcart_core_allowed_tags');  ?></h6>
                                                        <span class="position"><?php echo wp_kses($item['bio'], 'swiftcart_core_allowed_tags');  ?></span>
                                                    </div>
                                                </div>
                                                <?php if (!empty($item['button_label'])) : ?>
                                                    <a class="theme-btn style-one" <?php esc_attr(!empty($item['button_url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($item['button_url']['url']); ?>"><?php echo esc_html($item['button_label']); ?></a>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                        <div class="col-lg-7">
                                            <!--===  Case Image Box  ===-->
                                            <div class="ac-tab_image-box mb-50 text-xl-end swiftcart-tilt" data-tilt-options='{ "glare": false, "maxGlare": 0, "maxTilt": 5, "speed": 700, "scale": 1 }'>
                                                <?php swiftcart_elementor_rendered_image($item, 'image'); ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section><!--======  End Case Section  ======-->
    <!--======  Start Ai Avatar Section  ======-->

<?php endif; ?>