<?php if ('layout_two' == $settings['layout_type']) : ?>
    <!--======  Start How To Work Section  ======-->
    <section class="how-to-work">
        <div class="work-bg-wrapper pt-115">
            <div class="shape shape-one"><span><?php swiftcart_elementor_rendered_image($settings, 'layout_two_shape'); ?></span>
            </div>
            <div class="shape shape-two"><span><?php swiftcart_elementor_rendered_image($settings, 'layout_two_shape_two'); ?></span>
            </div>
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-lg-12">
                        <!--===  Section Title  ===-->
                        <div class="section-title text-center mb-55 wow fadeInDown">
                            <?php if (!empty($settings['layout_two_sec_sub_title'])) : ?>
                                <span class="sub-title"><?php swiftcart_elementor_rendered_image($settings, 'layout_two_subtitle_shape'); ?> <?php echo wp_kses($settings['layout_two_sec_sub_title'], 'swiftcart_core_allowed_tags');  ?> <?php swiftcart_elementor_rendered_image($settings, 'layout_two_subtitle_shape'); ?></span>
                            <?php endif; ?>
                            <?php if (!empty($settings['layout_two_sec_title'])) : ?>
                                <h2><?php echo wp_kses($settings['layout_two_sec_title'], 'swiftcart_core_allowed_tags');  ?></h2>
                            <?php endif; ?>
                            <?php if (!empty($settings['layout_two_sec_summary'])) : ?>
                                <p><?php echo wp_kses($settings['layout_two_sec_summary'], 'swiftcart_core_allowed_tags');  ?></p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12">
                        <!--===  Theme Tab  ===-->
                        <div class="theme-tabs style-three  mb-30 wow fadeInUp">
                            <ul class="nav nav-tabs justify-content-center">
                                <?php foreach ($settings['layout_two_tab_list'] as $index => $item) : $active = ($index == 0) ? 'active' : ''; ?>
                                    <li><button class="nav-link <?php echo esc_attr($active); ?>" data-bs-toggle="tab" data-bs-target="#step<?php echo esc_attr($index + 1) ?>"><?php echo esc_html($item['name']); ?></button></li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-12">
                        <!--===  Tab Content  ===-->
                        <div class="tab-content wow fadeInDown">
                            <!--===  Tab Pane  ===-->
                            <?php foreach ($settings['layout_two_tab_list'] as $index => $item) : $active = ($index == 0) ? 'active show' : ''; ?>
                                <div class="tab-pane fade <?php echo esc_attr($active); ?>" id="step<?php echo esc_attr($index + 1) ?>">
                                    <div class="step-box text-center swiftcart-tilt" data-tilt-options='{ "glare": false, "maxGlare": 0, "maxTilt": 5, "speed": 700, "scale": 1 }'>
                                        <?php swiftcart_elementor_rendered_image($item, 'image'); ?>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section><!--======  End How To Work Section  ======-->

<?php endif; ?>