<?php if ('layout_one' == $settings['layout_type']) : ?>

    <!--======  Start Team Details Section  ======-->
    <section class="team-details-section pt-120 pb-70">
        <div class="container">
            <div class="team-details-wrapper">
                <div class="row align-items-center">
                    <div class="col-xl-5">
                        <div class="member-image mb-50 wow fadeInLeft swiftcart-tilt" data-tilt-options='{ "glare": false, "maxGlare": 0, "maxTilt": 5, "speed": 700, "scale": 1 }'>
                            <?php swiftcart_elementor_rendered_image($settings, 'layout_one_img'); ?>
                        </div>
                    </div>
                    <div class="col-xl-7">
                        <div class="member-info mb-50 wow fadeInRight">
                            <h4><?php echo esc_html($settings['layout_one_sec_title']); ?></h4>
                            <span class="position"><?php echo wp_kses($settings['layout_one_sec_subtitle'], 'swiftcart_core_allowed_tags');  ?></span>
                            <p><?php echo wp_kses($settings['layout_one_sec_summary'], 'swiftcart_core_allowed_tags');  ?></p>
                            <p><?php echo wp_kses($settings['layout_one_sec_summary_two'], 'swiftcart_core_allowed_tags');  ?></p>
                            <ul class="social-link ml-0">
                                <?php if (is_array($settings['social_list'])) : ?>
                                    <?php foreach ($settings['social_list'] as $item) : ?>
                                        <li><a <?php esc_attr(!empty($item['url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($item['url']['url']) ?>"><?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true'], 'i'); ?></a></li>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section><!--======  End Team Details Section  ======-->
    <!--======  Start Skill Section  ======-->

<?php endif; ?>