<?php if ('layout_one' == $settings['layout_type']) : ?>
    <!--======  Start team Section  ======-->
    <section class="team-section pt-120 pb-90">
        <div class="container">
            <div class="row">
                <?php if (is_array($settings['team_list'])) : ?>
                    <?php foreach ($settings['team_list'] as $item) : ?>
                        <div class="col-xl-3 col-md-6 col-sm-12">
                            <!--===  Team Item  ===-->
                            <div class="team-item style-one mb-30 wow fadeInUp">
                                <div class="member-image">
                                    <?php swiftcart_elementor_rendered_image($item, 'image'); ?>
                                </div>
                                <div class="member-info">
                                    <div class="content">
                                        <?php if (!empty($item['name'])) : ?>
                                            <h4>
                                                <?php if (!empty($item['url']['url'])) : ?>
                                                    <a <?php esc_attr(!empty($item['url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($item['url']['url']) ?>"><?php echo esc_html($item['name']); ?></a>
                                                <?php else : ?>
                                                    <?php echo esc_html($item['name']); ?>
                                                <?php endif; ?>
                                            </h4>
                                        <?php endif; ?>
                                        <?php if (!empty($item['bio'])) : ?>
                                            <span class="position"><?php echo esc_html($item['bio']); ?></span>
                                        <?php endif; ?>
                                    </div>
                                    <div class="share-button">
                                        <div class="icon">
                                            <i class="flaticon-plus-positive-add-mathematical-symbol"></i>
                                        </div>
                                        <ul class="social-link ml-0">
                                            <?php echo wp_kses($item['social'], 'swiftcart_core_allowed_tags');  ?>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
        </div>
    </section><!--======  End team Section  ======-->

<?php endif; ?>