<?php if ('layout_three' == $settings['layout_type']) : ?>
    <?php global $post;
    $post_query = new \WP_Query(array(
        'post_type' => 'team',
        'order' => $settings['order'],
        'orderby', $settings['orderby'],
        'posts_per_page' => $settings['post_count']['size'],
        'offset' => $settings['post-offset']
    ));
    ?>
    <!-- agent area start -->
    <div class="agent-area bg-black pd-top-118 pd-bottom-90">
        <div class="container">
            <?php if ('yes' == $settings['heading_status']) : ?>
                <div class="section-title style-white text-center">
                    <?php if (!empty($settings['sub_title'])) : ?>
                        <h6><?php echo esc_html($settings['sub_title']); ?></h6>
                    <?php endif; ?>
                    <?php if (!empty($settings['title'])) : ?>
                        <h2 class="title"><?php echo wp_kses($settings['title'], 'swiftcart_core_allowed_tags');  ?></h2>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
            <div class="row">
                <?php
                if ($post_query->have_posts()) :
                    while ($post_query->have_posts()) : $post_query->the_post();
                        $team_meta = get_post_meta(get_the_ID(), 'swiftcart_team_meta', true);
                ?>
                        <div class="col-lg-3 col-sm-6">
                            <div class="single-agent-wrap style-2 text-center">
                                <div class="thumb">
                                    <?php the_post_thumbnail("swiftcart_team__160X160"); ?>
                                </div>
                                <div class="details">
                                    <h4><?php the_title(); ?></h4>
                                    <h6><?php echo esc_html($team_meta['bio']); ?></h6>
                                    <?php if (is_array($team_meta['social_profile'])) : ?>
                                        <ul class="social-area style-2">
                                            <?php foreach ($team_meta['social_profile'] as $social) : ?>
                                                <li>
                                                    <a href="<?php echo esc_url($social['social_url']); ?>" target="_blank">
                                                        <i class="<?php echo esc_attr($social['icon']); ?>" aria-hidden="true"></i>
                                                    </a>
                                                </li>
                                            <?php endforeach; ?>
                                        </ul>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                <?php endwhile;
                endif; ?>
            </div>
        </div>
    </div>
    <!-- agent area end -->
<?php endif; ?>