<?php if ('layout_one' == $settings['layout_type']) : ?>
    <!-- testimonial start -->
    <div class="sw-testimonial-one pt-80 pb-80 include-bg" data-bg="<?php echo esc_url($settings['bg_image']['url']); ?>">
        <div class="container">
            <div class="sw-testimonial-one__carousel swiftcart-owl__carousel owl-theme owl-carousel" data-owl-options='{
            "items": 3,
            "margin": 30,
            "smartSpeed": 700,
            "loop":true,
            "autoplay": true,
            "nav":false,
            "URLhashListener":true,
            "dots":false,
            "navText": ["<span class=\"icon-arrow-left\"></span>","<span class=\"icon-arrow\"></span>"],
            "responsive": {
                "0": {
                    "items": 1
                },
                "768": {
                    "items": 2
                },
                "1200": {
                    "items": 3
                }
            }
            }'>
                <?php if (is_array($settings['testimonial_list'])) : ?>
                    <?php foreach ($settings['testimonial_list'] as $item) : ?>
                        <div class="item">
                            <div class="sw-testimonial-one__item">
                                <div class="sw-testimonial-one__head">
                                    <div class="sw-testimonial-one__thumb">
                                        <?php swiftcart_elementor_rendered_image($item, 'image'); ?>
                                    </div>
                                    <div class="sw-testimonial-one__info">
                                        <?php if (!empty($item['name'])) : ?>
                                            <h3 class="sw-testimonial-one__name"><?php echo esc_html($item['name']); ?></h3>
                                        <?php endif; ?>
                                        <?php if (!empty($item['bio'])) : ?>
                                            <p class="sw-testimonial-one__bio"><?php echo esc_html($item['bio']); ?></p>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <?php if (!empty($item['testimonial_content'])) : ?>
                                    <p class="sw-testimonial-one__review"><?php echo esc_html($item['testimonial_content']); ?></p>
                                <?php endif; ?>
                                <?php if (!empty($item['rating']['size'])) : ?>
                                    <div class="sw-testimonial-one__ratting">
                                        <?php for ($i = 0; $i < $item['rating']['size']; $i++) : ?>
                                            <span><i class="icon-star"></i></span>
                                        <?php endfor; ?>
                                    </div>
                                <?php endif; ?>
                                <div class="sw-testimonial-one__quote">
                                    <?php swiftcart_elementor_rendered_image($item, 'quote'); ?>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <!-- testimonial end -->

<?php endif; ?>