<?php if ('layout_three' == $settings['layout_type']) : ?>

    <!-- testimonial start -->
    <div class="sw-testimonial-two pt-80 pb-80 include-bg">
        <div class="container">
            <div class="sw-sec-heading sw-sec-heading__three text-center">
                <?php if (!empty($settings['layout_three_title'])) : ?>
                    <h3 class="sw-sec-heading__title"><?php echo wp_kses($settings['layout_three_title'], 'swiftcart_core_allowed_tags');  ?></h3>
                <?php endif; ?>
                <?php if (!empty($settings['layout_three_summary'])) : ?>
                    <p class="sw-sec-heading__summary"><?php echo wp_kses($settings['layout_three_summary'], 'swiftcart_core_allowed_tags');  ?></p>
                <?php endif; ?>
            </div>
            <div class="sw-testimonial-two__carousel swiftcart-owl__carousel owl-theme owl-carousel" data-owl-options='{
            "items": 3,
            "margin": 30,
            "smartSpeed": 700,
            "loop":true,
            "autoplay": true,
            "nav":false,
            "URLhashListener":true,
            "dots":false,
            "navText": ["<span class=\"icon-arrow-left\"></span>","<span class=\"icon-arrow\"></span>"],
            "responsive": {
                "0": {
                    "items": 1
                },
                "768": {
                    "items": 2
                },
                "1200": {
                    "items": 3
                }
            }
            }'>
                <?php if (is_array($settings['layout_three_testimonial_list'])) : ?>
                    <?php foreach ($settings['layout_three_testimonial_list'] as $item) : ?>
                        <div class="item">
                            <div class="sw-testimonial-two__item">
                                <div class="sw-testimonial-two__thumb">
                                    <?php swiftcart_elementor_rendered_image($item, 'img'); ?>
                                </div>
                                <div class="sw-testimonial-two__head">
                                    <div class="sw-testimonial-two__info">
                                        <?php if (!empty($item['name'])) : ?>
                                            <h6 class="sw-testimonial-two__name"><?php echo esc_html($item['name']); ?></h6>
                                        <?php endif; ?>
                                        <?php if (!empty($item['bio'])) : ?>
                                            <p class="sw-testimonial-two__bio"><?php echo esc_html($item['bio']); ?></p>
                                        <?php endif; ?>
                                    </div>
                                    <?php if (!empty($item['rating']['size'])) : ?>
                                        <div class="sw-testimonial-two__ratting">
                                            <?php for ($i = 0; $i < $item['rating']['size']; $i++) : ?>
                                                <span><i class="icon-star"></i></span>
                                            <?php endfor; ?>

                                        </div>
                                    <?php endif; ?>
                                </div>
                                <?php if (!empty($item['testimonial_content'])) : ?>
                                    <p class="sw-testimonial-two__review"><?php echo esc_html($item['testimonial_content']); ?></p>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <!-- testimonial end -->

<?php endif; ?>