<?php if ('layout_two' == $settings['layout_type']) : ?>
    <!-- testimonil start  -->
    <div class="sw-testimonial-three pt-80 pb-80">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="sw-testimonial-three__carousel swiftcart-owl__carousel owl-carousel" data-owl-options='{
                    "loop": true,
                    "animateOut": "fadeOut",
                    "animateIn": "fadeIn",
                    "items": 1,
                    "autoplay": true,
                    "autoplayTimeout": 7000,
                    "smartSpeed": 1000,
                    "nav": false,
                    "navText": ["<span class=\"fa-solid fa-chevron-left\"></span>","<span class=\"fa-solid fa-chevron-right\"></span>"],
                    "dots": true,
                    "margin": 0
                    }'>
                        <?php if (is_array($settings['testimonial_list'])) : ?>
                            <?php foreach ($settings['testimonial_list'] as $item) : ?>
                                <div class="sw-testimonial-three__item">
                                    <div class="sw-testimonial-three__img">
                                        <?php swiftcart_elementor_rendered_image($item, 'image'); ?>
                                        <span><i class="fa-solid fa-quote-right"></i></span>
                                    </div>
                                    <?php if (!empty($item['name'])) : ?>
                                        <h3 class="sw-testimonial-three__name"><?php echo esc_html($item['name']); ?></h3>
                                    <?php endif; ?>
                                    <?php if (!empty($item['bio'])) : ?>
                                        <span class="sw-testimonial-three__bio"><?php echo esc_html($item['bio']); ?></span>
                                    <?php endif; ?>
                                    <?php if (!empty($item['testimonial_content'])) : ?>
                                        <p class="sw-testimonial-three__review"><?php echo wp_kses($item['testimonial_content'], 'swiftcart_core_allowed_tags'); ?></p>
                                    <?php endif; ?>
                                </div>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- testimonil end  -->
<?php endif; ?>