<?php if ('layout_four' == $settings['layout_type']) : ?>
    <!--======  Start Video Section  ======-->
    <section class="video-section">
        <div class="video-bg-wrapper pt-110 pb-90">
            <div class="shape shape-one"><span><?php swiftcart_elementor_rendered_image($settings, 'layout_four_shape_one'); ?></span></div>
            <div class="shape shape-two"><span><?php swiftcart_elementor_rendered_image($settings, 'layout_four_shape_two'); ?></span></div>
            <div class="shape shape-three"><span><?php swiftcart_elementor_rendered_image($settings, 'layout_four_shape_three'); ?></span></div>
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-lg-8">
                        <!--===  Section Title  ===-->
                        <div class="section-title text-center mb-55 wow fadeInDown">
                            <span class="sub-title"><?php swiftcart_elementor_rendered_image($settings, 'layout_four_subtitle_shape'); ?><?php echo wp_kses($settings['layout_four_subtitle'], 'swiftcart_core_allowed_tags');  ?><?php swiftcart_elementor_rendered_image($settings, 'layout_four_subtitle_shape'); ?></span>
                            <h2><?php echo wp_kses($settings['layout_four_title'], 'swiftcart_core_allowed_tags');  ?></h2>
                            <p> <?php echo wp_kses($settings['layout_four_summary'], 'swiftcart_core_allowed_tags');  ?></p>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <?php foreach ($settings['layout_four_list'] as $index => $item) : ?>
                        <div class="col-xl-4 col-md-6 col-sm-12">
                            <!--===  Features Image Card  ===-->
                            <div class="features-image-card mb-30 wow fadeInUp">
                                <div class="image">
                                    <?php swiftcart_elementor_rendered_image($item, 'image'); ?>
                                </div>
                                <div class="content">
                                    <h4><a <?php esc_attr(!empty($item['url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($item['url']['url']); ?>"><?php echo esc_html($item['title']) ?></a>
                                    </h4>
                                    <p><?php echo wp_kses($item['summary'], 'swiftcart_core_allowed_tags');  ?></p>
                                    <?php if (!empty($item['button_label'])) : ?>
                                        <a class="theme-btn style-two" <?php esc_attr(!empty($item['url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($item['url']['url']); ?>"><?php echo esc_html($item['button_label']); ?></a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </section><!--======  End Video Section  ======-->
<?php endif; ?>