<?php if ('layout_one' == $settings['layout_type']) : ?>
    <!--======  Start Intro Section  ======-->
    <section class="intro-section pb-120">
        <div class="container">
            <!--=== Intro Wrapper ===-->
            <div class="intro-wrapper">
                <div class="row align-items-center">
                    <div class="col-xl-6">
                        <!--=== Section Title ===-->
                        <div class="video-one_image-box p-r z-1 mb-50 wow fadeInLeft">
                            <div class="swiftcart-tilt" data-tilt-options='{ "glare": false, "maxGlare": 0, "maxTilt": 5, "speed": 700, "scale": 1 }'>
                                <?php swiftcart_elementor_rendered_image($settings, 'layout_one_img'); ?>
                                <?php if (!empty($settings['layout_one_video_url'])) : ?>
                                    <div class="play-button">
                                        <a href="<?php echo esc_url($settings['layout_one_video_url']); ?>" class="video-popup"><i class="flaticon-play-button-arrowhead"></i></a>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-6">
                        <!--=== Section Content Box ===-->
                        <div class="section-content-box text-white mb-50 wow fadeInRight">
                            <div class="section-title mb-55">
                                <span class="sub-title style-one"><?php echo wp_kses($settings['layout_one_subtitle'], 'swiftcart_core_allowed_tags');  ?></span>
                                <h2><?php echo wp_kses($settings['layout_one_title'], 'swiftcart_core_allowed_tags');  ?></h2>
                            </div>
                            <p><?php echo wp_kses($settings['layout_one_summary'], 'swiftcart_core_allowed_tags');  ?></p>

                            <?php if (is_array($settings['layout_one_list'])) : ?>
                                <ul class="circle-list style-one ml-0">
                                    <?php foreach ($settings['layout_one_list'] as $item) : ?>
                                        <li><?php echo wp_kses($item['title'], 'swiftcart_core_allowed_tags'); ?></li>
                                    <?php endforeach; ?>
                                </ul>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section><!--======  End Intro Section  ======-->

<?php endif; ?>