<?php if ('layout_three' == $settings['layout_type']) : ?>
    <!--======  Start Ai Voicecovers Section  ======-->
    <section class="ai-voiceovers-section">
        <div class="voiceover-wrapper p-r z-1 pt-120 pb-65">
            <div class="voiceover-bg"><span><?php swiftcart_elementor_rendered_image($settings, 'layout_three_bg'); ?></span></div>
            <div class="container">
                <div class="row">
                    <div class="col-xl-6">
                        <!--===  Voiceovers Tab Wrap  ===-->
                        <div class="voiceovers-tabs-wrap mb-50 wow fadeInLeft">
                            <!--===  Theme Tab  ===-->
                            <div class="theme-tabs style-two">
                                <ul class="nav nav-tabs">
                                    <?php foreach ($settings['layout_three_list'] as $index => $item) : $active = ($index == 0) ? 'active' : ''; ?>
                                        <li>
                                            <button class="nav-link <?php echo esc_attr($active); ?>" data-bs-toggle="tab" data-bs-target="#country<?php echo esc_attr($index + 1); ?>">
                                                <span><?php swiftcart_elementor_rendered_image($item, 'flag'); ?><?php echo esc_html($item['tab']) ?></span>
                                            </button>
                                        </li>
                                    <?php endforeach; ?>

                                </ul>
                            </div>
                            <!--===  Tab Content  ===-->
                            <div class="tab-content">
                                <?php foreach ($settings['layout_three_list'] as $index => $item) : $active = ($index == 0) ? 'active show' : ''; ?>
                                    <!--===  Tab Pane  ===-->
                                    <div class="tab-pane fade <?php echo esc_attr($active); ?>" id="country<?php echo esc_attr($index + 1); ?>">
                                        <div class="video-two_image-box text-center">
                                            <?php swiftcart_elementor_rendered_image($item, 'image'); ?>
                                            <div class="country"><?php swiftcart_elementor_rendered_image($item, 'flag'); ?></div>
                                            <a href="<?php echo esc_url($item['video_url']); ?>" class="video-popup"><i class="fas fa-play"></i></a>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-6">
                        <!--===  Section Content Box  ===-->
                        <div class="section-content-box mb-50 wow fadeInRight">
                            <div class="section-title mb-30">
                                <span class="sub-title"><?php swiftcart_elementor_rendered_image($settings, 'layout_three_subtitle_shape'); ?> <?php echo wp_kses($settings['layout_three_subtitle'], 'swiftcart_core_allowed_tags');  ?></span>
                                <h2><?php echo wp_kses($settings['layout_three_title'], 'swiftcart_core_allowed_tags');  ?></h2>
                            </div>
                            <ul class="circle-list style-one mb-45 ml-0">
                                <?php echo wp_kses($settings['layout_three_summary'], 'swiftcart_core_allowed_tags');  ?>

                            </ul>
                            <?php if (!empty($settings['layout_three_button_label'])) : ?>
                                <a class="theme-btn style-one" <?php esc_attr(!empty($settings['layout_three_button_url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($settings['layout_three_button_url']['url']); ?>"><?php echo esc_html($settings['layout_three_button_label']); ?></a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section><!--======  End Ai Voicecovers Section  ======-->
    <!--======  Start How To Work Section  ======-->
<?php endif; ?>