<?php if ('layout_two' == $settings['layout_type']) : ?>
    <!--======  Start Ai Avatar Section  ======-->
    <section class="ai-avatar-seciton bg_cover pt-120 pb-110" style="background-image: url(<?php echo esc_url($settings['layout_two_bg']['url']) ?>);">
        <div class="container">
            <div class="row">
                <div class="col-xl-5">
                    <div class="section-content-box mb-50 wow fadeInLeft">
                        <!--===  Section Title  ===-->
                        <div class="section-title mb-55">
                            <span class="sub-title"><?php swiftcart_elementor_rendered_image($settings, 'layout_two_subtitle_shape'); ?> <?php echo wp_kses($settings['layout_two_subtitle'], 'swiftcart_core_allowed_tags');  ?> </span>
                            <h2><?php echo wp_kses($settings['layout_two_title'], 'swiftcart_core_allowed_tags');  ?></h2>
                            <p><?php echo wp_kses($settings['layout_two_summary'], 'swiftcart_core_allowed_tags');  ?></p>
                        </div>
                        <?php if (!empty($settings['layout_two_button_label'])) : ?>
                            <a class="theme-btn style-one" <?php esc_attr(!empty($settings['layout_two_button_url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($settings['layout_two_button_url']['url']); ?>"><?php echo esc_html($settings['layout_two_button_label']); ?></a>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="col-xl-7">
                    <div class="row">
                        <?php foreach ($settings['layout_two_list'] as $item) : ?>
                            <div class="col-lg-4 col-md-6 col-sm-12">
                                <!--===  Avatar Item  ===-->
                                <div class="avatar-item style-one mb-10 wow fadeInDown">
                                    <div class="avatar-img">
                                        <?php swiftcart_elementor_rendered_image($item, 'image'); ?>
                                        <div class="hover-overlay">
                                            <a href="<?php echo esc_url($item['video_url']); ?>" class="video-popup"><i class="fas fa-play"></i></a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        </div>
    </section><!--======  End Ai Avatar Section  ======-->
    <!--======  Start Ai Voicecovers Section  ======-->
<?php endif; ?>