<?php if ('layout_one' == $settings['layout_type']) : ?>

    <!-- Volunteer area start -->
    <div class="volunteer-area pt-120 pb-90 rel z-1">
        <div class="container container-1170">
            <div class="row justify-content-center">
                <div class="col-xl-6 col-lg-8 col-md-10">
                    <div class="section-title text-center mb-60">
                        <?php if (!empty($settings['sub_title'])) : ?>
                            <span class="section-title__subtitle mb-10"><?php echo esc_html($settings['sub_title']); ?></span>
                        <?php endif; ?>
                        <?php if (!empty($settings['title'])) : ?>
                            <h3><?php echo wp_kses($settings['title'], 'swiftcart_core_allowed_tags');  ?></h3>
                        <?php endif; ?>
                        <?php if (!empty($settings['summary'])) : ?>
                            <p><?php echo esc_html($settings['summary']); ?></p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <div class="row justify-content-center">
                <?php
                if ($post_query->have_posts()) :
                    $index = 1;
                    while ($post_query->have_posts()) : $post_query->the_post();
                        $volunteer_meta = get_post_meta(get_the_ID(), 'swiftcart_volunteer_meta', true);
                ?>
                        <div class="col-xl-4 col-sm-6">
                            <div class="valunteer-item valunteer-item--<?php echo esc_attr($index); ?>">
                                <div class="valunteer-item__img">
                                    <?php the_post_thumbnail('swiftcart_volunteer__376X388'); ?>
                                    <div class="share">
                                        <button><i class="flaticon-share"></i></button>
                                        <?php if (is_array($volunteer_meta['social_profile'])) : ?>
                                            <div class="share__socials">
                                                <?php foreach ($volunteer_meta['social_profile'] as $social) : ?>
                                                    <a href="<?php echo esc_url($social['social_url']); ?>" style="background:<?php echo esc_attr($social['color']); ?>;" target="_blank"><i class="<?php echo esc_attr($social['icon']); ?>"></i></a>
                                                <?php endforeach; ?>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div class="valunteer-item__designation" style="background-image:url(<?php echo esc_url($volunteer_meta['bg_shape']['url']); ?>)">
                                    <h5><?php the_title(); ?></h5>
                                    <span><?php echo esc_html($volunteer_meta['designation']); ?></span>
                                </div>
                            </div>
                        </div>
                <?php $index++;
                    endwhile;
                endif; ?>
            </div>
        </div>
        <div class="valunteet-shapres">
            <?php if (!empty($settings['shape_one']['url'])) : ?>
                <img class="one top_image_bounce" src="<?php echo esc_url($settings['shape_one']['url']); ?>" alt="<?php echo esc_attr(swiftcart_core_get_thumbnail_alt($settings['shape_one']['id'])); ?>">
            <?php endif; ?>
            <?php if (!empty($settings['shape_two']['url'])) : ?>
                <img class="two left_image_bounce" src="<?php echo esc_url($settings['shape_two']['url']); ?>" alt="<?php echo esc_attr(swiftcart_core_get_thumbnail_alt($settings['shape_two']['id'])); ?>">
            <?php endif; ?>
            <?php if (!empty($settings['shape_three']['url'])) : ?>
                <img class="three right_image_bounce" src="<?php echo esc_url($settings['shape_three']['url']); ?>" alt="<?php echo esc_attr(swiftcart_core_get_thumbnail_alt($settings['shape_three']['id'])); ?>">
            <?php endif; ?>
            <?php if (!empty($settings['shape_four']['url'])) : ?>
                <img class="four top_image_bounce" src="<?php echo esc_url($settings['shape_four']['url']); ?>" alt="<?php echo esc_attr(swiftcart_core_get_thumbnail_alt($settings['shape_four']['id'])); ?>">
            <?php endif; ?>
        </div>
    </div>
    <!-- Volunteer area end -->

<?php endif; ?>