<?php if ('layout_three' == $settings['layout_type']) : ?>

    <!-- Volunteer area start -->
    <div class="volunteer-area-three pt-120 rel z-1">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-6 col-lg-8 col-md-10">
                    <div class="section-title text-center mb-60">
                        <?php if (!empty($settings['sub_title'])) : ?>
                            <span class="section-title__subtitle mb-10"><?php echo esc_html($settings['sub_title']); ?></span>
                        <?php endif; ?>
                        <?php if (!empty($settings['title'])) : ?>
                            <h3><?php echo wp_kses($settings['title'], 'swiftcart_core_allowed_tags');  ?></h3>
                        <?php endif; ?>
                        <?php if (!empty($settings['summary'])) : ?>
                            <p><?php echo esc_html($settings['summary']); ?></p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <div class="row justify-content-center">
                <?php
                if ($post_query->have_posts()) :
                    while ($post_query->have_posts()) : $post_query->the_post();
                        $volunteer_meta = get_post_meta(get_the_ID(), 'swiftcart_volunteer_meta', true);
                ?>
                        <div class="col-xl-3 col-sm-6">
                            <div class="valunteer-item valunteer-item--three">
                                <div class="valunteer-item__img">
                                    <?php the_post_thumbnail('swiftcart_volunteer__306X353'); ?>
                                </div>
                                <div class="valunteer-item__designation">
                                    <h4><?php the_title(); ?></h4>
                                    <span><?php echo esc_html($volunteer_meta['designation']); ?></span>
                                    <?php if (is_array($volunteer_meta['social_profile'])) : ?>
                                        <div class="share__socials">
                                            <?php foreach ($volunteer_meta['social_profile'] as $social) : ?>
                                                <a href="<?php echo esc_url($social['social_url']); ?>" style="background:<?php echo esc_attr($social['color']); ?>;"><i class="<?php echo esc_attr($social['icon']); ?>"></i></a>
                                            <?php endforeach; ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                <?php endwhile;
                endif; ?>
            </div>
        </div>
    </div>
    <!-- Volunteer area end -->

<?php endif; ?>