<?php if ('layout_two' == $settings['layout_type']) : ?>

    <!-- Volunteer area start -->
    <div class="volunteer-area-two pt-120 pb-90 rel z-1">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-6 col-lg-8 col-md-10">
                    <div class="section-title text-center mb-60">
                        <?php if (!empty($settings['sub_title'])) : ?>
                            <span class="section-title__subtitle mb-10"><?php echo esc_html($settings['sub_title']); ?></span>
                        <?php endif; ?>
                        <?php if (!empty($settings['title'])) : ?>
                            <h3><?php echo wp_kses($settings['title'], 'swiftcart_core_allowed_tags');  ?></h3>
                        <?php endif; ?>
                        <?php if (!empty($settings['summary'])) : ?>
                            <p><?php echo esc_html($settings['summary']); ?></p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <div class="row justify-content-center">
                <?php
                if ($post_query->have_posts()) :
                    $index = 1;
                    while ($post_query->have_posts()) : $post_query->the_post();
                        $volunteer_meta = get_post_meta(get_the_ID(), 'swiftcart_volunteer_meta', true);
                ?>
                        <div class="col-xl-3 col-sm-6">
                            <div class="valunteer-two-item">
                                <div class="valunteer-two-item__img">
                                    <?php the_post_thumbnail('swiftcart_volunteer__306X353'); ?>
                                </div>
                                <div class="valunteer-two-item__des valunteer-two-item__des--<?php echo esc_attr($index); ?>">
                                    <h5><?php the_title(); ?></h5>
                                    <span><?php echo esc_html($volunteer_meta['designation']); ?></span>
                                </div>
                            </div>
                        </div>
                <?php $index++;
                    endwhile;
                endif; ?>
            </div>
        </div>
    </div>
    <!-- Volunteer area end -->

<?php endif; ?>