<?php

/**
 * Elementor Widget
 * @package SWIFTCART
 * @since 1.0.0
 */

namespace Elementor;

class Swiftcart_About_Widget extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'swiftcart-about-widget';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__('About', 'swiftcart-core');
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-product-info';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return ['swiftcart_widgets'];
	}

	/**
	 * Register Elementor widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls() {

		/*
		** Layout
		*/
		$this->start_controls_section(
			'layout_section',
			[
				'label' => esc_html__('Layout', 'swiftcart-core'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout_type',
			[
				'label' => esc_html__('Select Layout', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'default' => 'layout_one',
				'options' => [
					'layout_one' => esc_html__('Layout One', 'swiftcart-core'),
					// 'layout_two' => esc_html__('Layout Two', 'swiftcart-core'),
					// 'layout_three' => esc_html__('Layout Three', 'swiftcart-core'),
					// 'layout_four' => esc_html__('Layout Four', 'swiftcart-core')
				]
			]
		);

		$this->end_controls_section();

		include  swiftcart_get_elementor_option('about-one-option.php');
		// include  swiftcart_get_elementor_option('about-two-option.php');
		// include  swiftcart_get_elementor_option('about-three-option.php');

		/*
		** General style
		*/
		$this->start_controls_section(
			'general_style',
			[
				'label' => esc_html__('Style Options', 'swiftcart-core'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		swiftcart_core_elementor_general_style_options($this, 'Sub Title', '{{WRAPPER}} .sw-about-one__subtitle', ['layout_one']);

		swiftcart_core_elementor_general_style_options($this, 'Title', '{{WRAPPER}} .sw-about-one__title', ['layout_one', 'layout_two', 'layout_three']);

		swiftcart_core_elementor_general_style_options($this, 'Summary', '{{WRAPPER}} .sw-about-one__info', ['layout_one', 'layout_two', 'layout_three']);

		swiftcart_core_elementor_general_style_options($this, 'List ', '{{WRAPPER}} .sw-about-one__checklist li', ['layout_two']);

		swiftcart_core_elementor_button_style_options($this, 'Button', '{{WRAPPER}} .swiftcart-btn', '{{WRAPPER}} .swiftcart-btn:hover', ['layout_one', 'layout_two']);

		$this->end_controls_section();
	}

	/**
	 * Render Elementor widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

		include swiftcart_get_template('about-one.php');
		// include swiftcart_get_template('about-two.php');
		// include swiftcart_get_template('about-three.php');
		// include swiftcart_get_template('about-four.php');
	}
}

Plugin::instance()->widgets_manager->register(new Swiftcart_About_Widget());
