<?php

/**
 * Elementor Widget
 * @package SWIFTCART
 * @since 1.0.0
 */

namespace Elementor;

class Swiftcart_Banner_Widget extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'swiftcart-banner-widget';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__('Banner', 'swiftcart-core');
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-product-info';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return ['swiftcart_widgets'];
	}

	/**
	 * Register Elementor widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls() {

		$this->start_controls_section(
			'layout_section',
			[
				'label' => esc_html__('Layout', 'swiftcart-core'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout_type',
			[
				'label' => esc_html__('Select Layout', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'default' => 'layout_one',
				'options' => [
					'layout_one' => esc_html__('Layout One', 'swiftcart-core'),
					'layout_two' => esc_html__('Layout Two', 'swiftcart-core'),
					'layout_three' => esc_html__('Layout Three', 'swiftcart-core'),
					'layout_four' => esc_html__('Layout Four', 'swiftcart-core'),
					'layout_five' => esc_html__('Layout Five', 'swiftcart-core'),
					'layout_six' => esc_html__('Layout Six', 'swiftcart-core'),
					'layout_seven' => esc_html__('Layout Seven', 'swiftcart-core'),
					'layout_eight' => esc_html__('Layout Eight', 'swiftcart-core'),
					'layout_nine' => esc_html__('Layout Nine', 'swiftcart-core'),
					'layout_ten' => esc_html__('Layout Ten', 'swiftcart-core'),
				]
			]
		);

		$this->end_controls_section();


		include  swiftcart_get_elementor_option('banner-one-option.php');
		include  swiftcart_get_elementor_option('banner-two-option.php');
		// include  swiftcart_get_elementor_option('banner-three-option.php');

		//General style
		$this->start_controls_section(
			'general_style',
			[
				'label' => esc_html__('Style Options', 'swiftcart-core'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		swiftcart_core_elementor_general_style_options($this, 'Box', '{{WRAPPER}} .sw-banner-two__item,{{WRAPPER}} .sw-banner-three__item', ['layout_one', 'layout_two', 'layout_three'], 'background', false);

		swiftcart_core_elementor_general_style_options($this, 'Subitle', '{{WRAPPER}} .sw-banner-three__subtitle', ['layout_two', 'layout_three']);

		$this->add_control(
			'bg-color',
			[
				'label' => esc_html__('Background Color', 'textdomain'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sw-banner-three__subtitle' => 'background-color: {{VALUE}};',
				],
				'condition' => [
					'layout_type' => ['layout_two']
				]
			]
		);

		swiftcart_core_elementor_general_style_options($this, 'Title', '{{WRAPPER}} .el-banner-title', ['layout_one', 'layout_two', 'layout_three']);
		swiftcart_core_elementor_general_style_options($this, 'Summary', '{{WRAPPER}} .el-banner-info', ['layout_one', 'layout_two', 'layout_three']);
		swiftcart_core_elementor_general_style_options($this, 'Summary Span', '{{WRAPPER}} .el-banner-info span', ['layout_one', 'layout_three']);
		swiftcart_core_elementor_button_style_options($this, 'Button', '{{WRAPPER}} .swiftcart-btn-white,{{WRAPPER}} .swiftcart-btn', '{{WRAPPER}} .swiftcart-btn-white:hover,{{WRAPPER}} .swiftcart-btn:hover', ['layout_one', 'layout_three']);

		$this->end_controls_section();
	}

	/**
	 * Render Elementor widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		include swiftcart_get_template('banner-one.php');
		include swiftcart_get_template('banner-two.php');
		include swiftcart_get_template('banner-three.php');
		include swiftcart_get_template('banner-four.php');
		include swiftcart_get_template('banner-five.php');
		include swiftcart_get_template('banner-six.php');
		include swiftcart_get_template('banner-seven.php');
		include swiftcart_get_template('banner-eight.php');
		include swiftcart_get_template('banner-nine.php');
		include swiftcart_get_template('banner-ten.php');
	}
}

Plugin::instance()->widgets_manager->register(new Swiftcart_Banner_Widget());
