<?php

/**
 * Elementor Widget
 * @package SWIFTCART
 * @since 1.0.0
 */

namespace Elementor;

class Swiftcart_Faq_Widget extends Widget_Base
{

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name()
	{
		return 'swiftcart-faq-widget';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title()
	{
		return esc_html__('FAQ', 'swiftcart-core');
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon()
	{
		return 'eicon-product-info';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories()
	{
		return ['swiftcart_widgets'];
	}

	/**
	 * Register Elementor widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls()
	{

		/*
		* Layout Section
		*/
		$this->start_controls_section(
			'layout_section',
			[
				'label' => __('Layout', 'swiftcart-core'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout_type',
			[
				'label' => __('Select Layout', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'default' => 'layout_one',
				'options' => [
					'layout_one' => __('Layout One', 'swiftcart-core'),
					// 'layout_two' => __('Layout Two', 'swiftcart-core'),
					// 'layout_three' => __('Layout Three', 'swiftcart-core'),
					// 'layout_four' => __('Layout Four', 'swiftcart-core'),
				]
			]
		);

		$this->end_controls_section();

		include  swiftcart_get_elementor_option('faq-one-option.php');
		// include  swiftcart_get_elementor_option('faq-three-option.php');
		/*
		**General style
		*/
		$this->start_controls_section(
			'general_style',
			[
				'label' => esc_html__('Style Options', 'swiftcart-core'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);


		swiftcart_core_elementor_general_style_options($this, 'Faq Sub Title', '{{WRAPPER}} .sub-title.style-one,.home-two .sub-title, {{WRAPPER}} .faq-page-area-two .section-title h2', ['layout_one', 'layout_two']);

		swiftcart_core_elementor_general_style_options($this, 'Faq Title', '{{WRAPPER}} .section-title h2,.home-two .section-title h2,{{WRAPPER}} .sidebar-nav-widget h6', ['layout_one', 'layout_two', 'layout_three']);

		swiftcart_core_elementor_general_style_options($this, 'Faq Summary', '.home-two .section-title p, {{WRAPPER}} .faq-page-area-two .section-title p, {{WRAPPER}} .faq-page-area .section-title p', ['layout_two']);

		swiftcart_core_elementor_general_style_options($this, 'Faq Question', '{{WRAPPER}} .accordion-card.style-one .accordion-header h6.accordion-title,{{WRAPPER}} .accordion-card.style-two .accordion-header h6', ['layout_one', 'layout_two', 'layout_three']);

		swiftcart_core_elementor_general_style_options($this, 'Faq Answer', '{{WRAPPER}} .accordion-card.style-one .accordion-content p, .accordion-card.style-two .accordion-content p', ['layout_one', 'layout_two', 'layout_three']);

		$this->end_controls_section();
	}

	/**
	 * Render Elementor widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render()
	{
		$settings = $this->get_settings_for_display();
		include swiftcart_get_template('faq-one.php');
		// include swiftcart_get_template('faq-two.php');
		// include swiftcart_get_template('faq-three.php');
		// include swiftcart_get_template('faq-four.php');
	}
}

Plugin::instance()->widgets_manager->register(new Swiftcart_Faq_Widget());
