<?php

/**
 * Elementor Widget
 * @package SWIFTCART
 * @since 1.0.0
 */

namespace Elementor;

class Swiftcart_Features_Widget extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'swiftcart-Features-widget';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__('Features', 'swiftcart-core');
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-product-info';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return ['swiftcart_widgets'];
	}

	/**
	 * Register Elementor widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls() {

		$this->start_controls_section(
			'layout_section',
			[
				'label' => __('Layout', 'swiftcart-core'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout_type',
			[
				'label' => __('Select Layout', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'default' => 'layout_one',
				'options' => [
					'layout_one' => __('Layout One', 'swiftcart-core'),
					'layout_two' => __('Layout Two', 'swiftcart-core'),
					'layout_three' => __('Layout Three', 'swiftcart-core'),
					'layout_four' => __('Layout Four', 'swiftcart-core'),
					// 'layout_five' => __('Layout Five', 'swiftcart-core'),
					// 'layout_six' => __('Layout Six', 'swiftcart-core'),
				]
			]
		);

		$this->end_controls_section();

		include  swiftcart_get_elementor_option('feature-one-option.php');
		include  swiftcart_get_elementor_option('feature-two-option.php');
		include  swiftcart_get_elementor_option('feature-three-option.php');
		include  swiftcart_get_elementor_option('feature-four-option.php');
		// include  swiftcart_get_elementor_option('feature-five-option.php');
		// include  swiftcart_get_elementor_option('feature-six-option.php');

	//General style
		$this->start_controls_section(
			'general_style',
			[
				'label' => esc_html__('Style Options', 'swiftcart-core'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		swiftcart_core_elementor_general_style_options($this, 'Sec Sub Title', '{{WRAPPER}} .sub-title.style-one,{{WRAPPER}} .sub-title', ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_five']);

		swiftcart_core_elementor_general_style_options($this, 'Sec Title', '{{WRAPPER}} .section-title h2', ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_five', 'layout_six']);

		swiftcart_core_elementor_general_style_options($this, 'Sec Summary', '{{WRAPPER}} .text-one_content-box > p,{{WRAPPER}} .section-title p,{{WRAPPER}} .features-section .text-box p', ['layout_three', 'layout_four', 'layout_five', 'layout_six']);

		swiftcart_core_elementor_link_style_options($this, 'Feature Title', '{{WRAPPER}} .iconic-info-box.style-two .content h4', '{{WRAPPER}} .single-service-wrap .single-service-details h4 a:hover', ['layout_one']);

		swiftcart_core_elementor_general_style_options($this, 'Step Title', '{{WRAPPER}} .iconic-number-box.style-one .content h6,{{WRAPPER}} .iconic-info-box.style-three .content h6,{{WRAPPER}} .iconic-info-box.style-four .content h5', ['layout_two', 'layout_five', 'layout_six']);
		swiftcart_core_elementor_general_style_options($this, 'Check List', '{{WRAPPER}} .text-one_content-box ul.check-list li', ['layout_three']);

		swiftcart_core_elementor_general_style_options($this, 'Feature Summary', '{{WRAPPER}} .iconic-info-box.style-two .content h4 p, {{WRAPPER}} .iconic-number-box.style-one .content p,{{WRAPPER}} .iconic-info-box.style-three .content p, .iconic-info-box.style-four .content p', ['layout_one', 'layout_two', 'layout_five', 'layout_six']);

		swiftcart_core_elementor_button_style_options($this, 'Icon', '{{WRAPPER}} .iconic-info-box.style-three .icon', '{{WRAPPER}} .iconic-info-box.style-three .icon:hover', ['layout_five']);

		swiftcart_core_elementor_button_style_options($this, 'Button', '.home-two .theme-btn.style-one', '.home-two .theme-btn.style-one:hover', ['layout_three']);

		swiftcart_core_elementor_button_style_options($this, 'Tab Button', '{{WRAPPER}} .theme-tabs .nav-link', '{{WRAPPER}} .theme-tabs .nav-link:hover', ['layout_four']);
		swiftcart_core_elementor_button_style_options($this, 'Tab Button Active', '{{WRAPPER}} .theme-tabs .nav-link.active', '{{WRAPPER}} .theme-tabs .nav-link.active:hover', ['layout_four']);

		$this->end_controls_section();
	}

	/**
	 * Render Elementor widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		include swiftcart_get_template('features-one.php');
		include swiftcart_get_template('features-two.php');
		include swiftcart_get_template('features-three.php');
		include swiftcart_get_template('features-four.php');
		// include swiftcart_get_template('features-five.php');
		// include swiftcart_get_template('features-six.php');
	}
}

Plugin::instance()->widgets_manager->register(new Swiftcart_Features_Widget());
