<?php

/**
 * Elementor Widget
 * @package SWIFTCART
 * @since 1.0.0
 */

namespace Elementor;

class Swiftcart_Footer_About_Widget extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'swiftcart-footer-about-widget';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__('Footer About', 'swiftcart-core');
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-product-info';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return ['swiftcart_widgets'];
	}

	/**
	 * Register Elementor widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls() {

		$this->start_controls_section(
			'layout_section',
			[
				'label' => __('Layout', 'swiftcart-core'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout_type',
			[
				'label' => __('Select Layout', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'default' => 'layout_one',
				'options' => [
					'layout_one' => __('Layout One', 'swiftcart-core'),
					'layout_two' => __('Layout Two', 'swiftcart-core'),
				]
			]
		);

		$this->end_controls_section();


		/*
		* content
		*/
		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__('Content', 'swiftcart-core'),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);


		$this->add_control(
			'summary',
			[
				'label' => esc_html__('Summary', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__('Add Content', 'swiftcart-core'),
				'default' => esc_html__('Add Content', 'swiftcart-core'),
			]
		);

		$social_icon = new \Elementor\Repeater();

		$social_icon->add_control(
			'icon',
			[
				'label' => esc_html__('Choose Icon', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fab fa-facebook-f',
					'library' => 'swiftcart-icon',
				],

			]
		);

		$social_icon->add_control(
			'social_url',
			[
				'label' => esc_html__('Social Url', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => esc_html__('#', 'swiftcart-core'),
				'show_external' => true,
				'default' => [
					'url' => '#',
					'is_external' => false,
					'nofollow' => false,
				],
				'show_label' => false,
			]
		);

		$this->add_control(
			'social_icon',
			[
				'label' => esc_html__('Social Icon', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $social_icon->get_controls(),
				'prevent_empty' => false,
				'default' => [
					[
						'social_url' => [
							'url' => '#',
							'is_external' => false,
							'nofollow' => false,
						],
					]
				],
				'condition' => [
					'layout_type' => ['layout_one']
				],
			]
		);



		$cta_List = new \Elementor\Repeater();

		$cta_List->add_control(
			'icon',
			[
				'label' => esc_html__('Counter Icon', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'flaticon-solidarity',
					'library' => 'swiftcart-icon',
				],

			]
		);

		$cta_List->add_control(
			'summary',
			[
				'label' => esc_html__('Summary', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__('Add Content', 'swiftcart-core'),
				'default' => esc_html__('Add Content', 'swiftcart-core'),
			]
		);


		$this->add_control(
			'counter',
			[
				'label' => esc_html__('Counter List', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $cta_List->get_controls(),
				'prevent_empty' => false,
				'show_external' => true,
				'title_field' => '{{{ summary }}}',
				'default' => [
					[
						'summary' => esc_html__('Add Text', 'swiftcart-core')
					],
				],
				'condition' => [
					'layout_type' => ['layout_one']
				],
			]
		);

		$this->end_controls_section();




		/*
		* Logo
		*/
		$this->start_controls_section(
			'logo_section',
			[
				'label' => __('Logo', 'swiftcart-core'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'logo_type',
			[
				'label' => esc_html__('Logo Type', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'image',
				'options' => [
					'image'  => esc_html__('Image', 'swiftcart-core'),
					'icon' => esc_html__('Icon Logo', 'swiftcart-core'),
				],
			]
		);

		$this->add_control(
			'logo',
			[
				'label' => __('Image Logo', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'condition' => [
					'logo_type' => 'image'
				],
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_control(
			'icon_logo',
			[
				'label' => __('Icon Logo', 'swiftcart-addon'),
				'type' => \Elementor\Controls_Manager::ICONS,
				'condition' => [
					'logo_type' => 'icon',
				],
			]
		);

		$this->add_control(
			'logo_dimension',
			[
				'label' => __('Logo Dimension', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::IMAGE_DIMENSIONS,
				'description' => __('Set Custom Logo Size.', 'swiftcart-core'),
				'default' => [
					'width' => '177',
					'height' => '48',
				],
			]
		);

		$this->end_controls_section();



		//General style
		$this->start_controls_section(
			'general_style',
			[
				'label' => esc_html__('Style Options', 'swiftcart-core'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		swiftcart_core_elementor_general_style_options($this, 'Summary', '{{WRAPPER}} .sw-footer-one__about', ['layout_one', 'layout_two']);
		swiftcart_core_elementor_button_style_options($this, 'Social Icon', '{{WRAPPER}} .sw-footer-one__social a', '{{WRAPPER}} .sw-footer-one__social a:hover', ['layout_one']);


		swiftcart_core_elementor_general_style_options($this, 'Cta Text', '{{WRAPPER}} .sw-footer-one__cta span', ['layout_one']);

		swiftcart_core_elementor_general_style_options($this, 'Counter Icon', '{{WRAPPER}} .sw-footer-one__cta span i', ['layout_one']);


		$this->end_controls_section();
	}

	/**
	 * Render Elementor widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		include swiftcart_get_template('footer-about-one.php');
		// include swiftcart_get_template('footer-about-two.php');
	}
}

Plugin::instance()->widgets_manager->register(new Swiftcart_Footer_About_Widget());
