<?php

/**
 * Elementor Widget
 * @package SWIFTCART
 * @since 1.0.0
 */

namespace Elementor;

class Swiftcart_Footer_Contact_Widget extends Widget_Base
{

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name()
	{
		return 'swiftcart-footer-contact-widget';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title()
	{
		return esc_html__('Footer Contact', 'swiftcart-core');
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon()
	{
		return 'eicon-product-info';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories()
	{
		return ['swiftcart_widgets'];
	}

	/**
	 * Register Elementor widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls()
	{

		$this->start_controls_section(
			'layout_section',
			[
				'label' => __('Layout', 'swiftcart-core'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout_type',
			[
				'label' => __('Select Layout', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'default' => 'layout_one',
				'options' => [
					'layout_one' => __('Layout One', 'swiftcart-core'),
				]
			]
		);

		$this->end_controls_section();


		/*
		* content
		*/
		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__('Content', 'swiftcart-core'),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);


		$this->add_control(
			'title',
			[
				'label' => esc_html__('Widget Title', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__('Add Title', 'swiftcart-core'),
				'default' => esc_html__('Add Title', 'swiftcart-core'),
			]
		);
		$this->add_control(
			'summary',
			[
				'label' => esc_html__('Summary', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__('Add Content', 'swiftcart-core'),
				'default' => esc_html__('Add Content', 'swiftcart-core'),
			]
		);

		$footer_cta = new \Elementor\Repeater();

		$footer_cta->add_control(
			'icon',
			[
				'label' => esc_html__('Choose Icon', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-map-marker-alt',
					'library' => 'swiftcart-icon',
				],

			]
		);
		
		$footer_cta->add_control(
			'info',
			[
				'label' => esc_html__('Info', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__('Add Info', 'swiftcart-core'),
				'default' => esc_html__('Add Info', 'swiftcart-core'),
			]
		);
		$this->add_control(
			'footer_cta',
			[
				'label' => esc_html__('Cta List', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $footer_cta->get_controls(),
				'prevent_empty' => false,
				'default' => [
					[
						'info' => esc_html__('Add Info', 'swiftcart-core')
					],
				],
				'condition' => [
					'layout_type' => ['layout_one']
				],
			]
		);

		$this->end_controls_section();



		//General style
		$this->start_controls_section(
			'general_style',
			[
				'label' => esc_html__('Style Options', 'swiftcart-core'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		swiftcart_core_elementor_general_style_options($this, 'Title', '{{WRAPPER}} .footer-area .widget_about p:last-child', ['layout_one']);
		swiftcart_core_elementor_general_style_options($this, 'Summary', '{{WRAPPER}} .footer-area .widget_about p', ['layout_one']);


		$this->end_controls_section();
	}

	/**
	 * Render Elementor widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render()
	{
		$settings = $this->get_settings_for_display();
		include swiftcart_get_template('footer-contact-one.php');
	}
}

Plugin::instance()->widgets_manager->register(new Swiftcart_Footer_Contact_Widget());
