<?php

/**
 * Elementor Widget
 * @package SWIFTCART
 * @since 1.0.0
 */

namespace Elementor;

class Swiftcart_Footer_Copyright_Widget extends Widget_Base
{

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name()
	{
		return 'swiftcart-footer-copyright-widget';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title()
	{
		return esc_html__('Footer Copyright', 'swiftcart-core');
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon()
	{
		return 'eicon-product-info';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories()
	{
		return ['swiftcart_widgets'];
	}

	/**
	 * Register Elementor widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls()
	{
		/*
		* Layout
		*/
		$this->start_controls_section(
			'layout_section',
			[
				'label' => __('Layout', 'swiftcart-core'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout_type',
			[
				'label' => __('Select Layout', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'default' => 'layout_one',
				'options' => [
					'layout_one' => __('Layout One', 'swiftcart-core'),
				]
			]
		);

		$this->end_controls_section();


		/*
		* content
		*/
		$this->start_controls_section(
			'content_section',
			[
				'label' => __('Content', 'swiftcart-core'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'copyright_text',
			[
				'label' => __('CopyRight Text', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => __('Add Text', 'swiftcart-core'),
				'default' => __('© Copyright 2022 All Right Reserved', 'swiftcart-core')
			]
		);

		$this->end_controls_section();

		//General style
		$this->start_controls_section(
			'general_style',
			[
				'label' => esc_html__('Style Options', 'swiftcart-core'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		swiftcart_core_elementor_general_style_options($this, 'CopyRight Text', '{{WRAPPER}} .sw-footer-one-copyright p', ['layout_one', 'layout_two']);



		$this->end_controls_section();
	}

	/**
	 * Render Elementor widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render()
	{
		$settings = $this->get_settings_for_display();
		include swiftcart_get_template('footer-copyright-one.php');
	}
}

Plugin::instance()->widgets_manager->register(new Swiftcart_Footer_Copyright_Widget());
