<?php

/**
 * Elementor Widget
 * @package SWIFTCART
 * @since 1.0.0
 */

namespace Elementor;

class Swiftcart_Footer_Top_Info_Widget extends Widget_Base
{

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name()
	{
		return 'swiftcart-footer-top-infp-widget';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title()
	{
		return esc_html__('Footer Top Info', 'swiftcart-core');
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon()
	{
		return 'eicon-product-info';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories()
	{
		return ['swiftcart_widgets'];
	}

	/**
	 * Register Elementor widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls()
	{
		/*
		* Layout
		*/
		$this->start_controls_section(
			'layout_section',
			[
				'label' => __('Layout', 'swiftcart-core'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout_type',
			[
				'label' => __('Select Layout', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'default' => 'layout_one',
				'options' => [
					'layout_one' => __('Layout One', 'swiftcart-core'),
				]
			]
		);

		$this->end_controls_section();
/*
		* Logo
		*/
		$this->start_controls_section(
			'logo_section',
			[
				'label' => __('Logo', 'swiftcart-core'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'logo',
			[
				'label' => __('Image Logo', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);


		$this->add_control(
			'logo_dimension',
			[
				'label' => __('Logo Dimension', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::IMAGE_DIMENSIONS,
				'description' => __('Set Custom Logo Size.', 'swiftcart-core'),
				'default' => [
					'width' => '177',
					'height' => '48',
				],
			]
		);

		$this->end_controls_section();
		/*
		* content
		*/
		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__('Content', 'swiftcart-core'),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);


		$social_icon = new \Elementor\Repeater();

		$social_icon->add_control(
			'icon',
			[
				'label' => esc_html__('Choose Icon', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fab fa-facebook-f',
					'library' => 'swiftcart-icon',
				],

			]
		);

		$social_icon->add_control(
			'social_url',
			[
				'label' => esc_html__('Social Url', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => esc_html__('#', 'swiftcart-core'),
				'show_external' => true,
				'default' => [
					'url' => '#',
					'is_external' => false,
					'nofollow' => false,
				],
				'show_label' => false,
			]
		);

		$this->add_control(
			'social_icon',
			[
				'label' => esc_html__('Social Icon', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $social_icon->get_controls(),
				'prevent_empty' => false,
				'default' => [
					[
						'social_url' => [
							'url' => '#',
							'is_external' => false,
							'nofollow' => false,
						],
					]
				],
				'condition' => [
					'layout_type' => ['layout_one']
				],
			]
		);

		$this->end_controls_section();


		/*
		** Content style
		*/
		$this->start_controls_section(
			'content_style',
			[
				'label' => esc_html__('Content Style', 'swiftcart-core'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		swiftcart_core_elementor_button_style_options($this, 'Socail Icon', '{{WRAPPER}} .social-area li a', '{{WRAPPER}} .social-area li a:hover', ['layout_one','layout_three']);


		$this->end_controls_section();
	}

	/**
	 * Render Elementor widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render()
	{
		$settings = $this->get_settings_for_display();
		include swiftcart_get_template('footer-top-info.php');
	}
}

Plugin::instance()->widgets_manager->register(new Swiftcart_Footer_Top_Info_Widget());
