<?php

/**
 * Elementor Widget
 * @package SWIFTCART
 * @since 1.0.0
 */

namespace Elementor;

class Swiftcart_Gallery_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name()
    {
        return 'swiftcart-gallery-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title()
    {
        return esc_html__('Gallery', 'swiftcart-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon()
    {
        return 'eicon-product-info';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @since 1.0.0
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories()
    {
        return ['swiftcart_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function _register_controls()
    {

        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'swiftcart-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'swiftcart-core'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'swiftcart-core'),
                    // 'layout_two' => __('Layout Two', 'swiftcart-core'),
                ]
            ]
        );

        $this->end_controls_section();

        include  swiftcart_get_elementor_option('gallery-one-option.php');


        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Style Options', 'swiftcart-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        swiftcart_core_typo_and_color_options($this, 'Fun Fact Title', '{{WRAPPER}} .single-exp-inner.style-white h5', ['layout_one']);
        swiftcart_core_typo_and_color_options($this, 'Fun Fact Count', '{{WRAPPER}} .counter', ['layout_one']);
        swiftcart_core_typo_and_color_options($this, 'Fun Sign', '{{WRAPPER}} .single-exp-inner.style-white h2 sub', ['layout_one']);

        $this->end_controls_section();
    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include swiftcart_get_template('gallery-one.php');
    }
}

Plugin::instance()->widgets_manager->register(new Swiftcart_Gallery_Widget());
