<?php

/**
 * Elementor Widget
 * @package SWIFTCART
 * @since 1.0.0
 */

namespace Elementor;

class Swiftcart_Header_Widget extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'swiftcart-Header-widget';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__('Header', 'swiftcart-core');
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-product-info';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return ['swiftcart_widgets'];
	}

	/**
	 * Register Elementor widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls() {


		/*
		* Layout
		*/
		$this->start_controls_section(
			'layout_section',
			[
				'label' => __('Layout', 'swiftcart-core'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout_type',
			[
				'label' => __('Select Layout', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'default' => 'layout_one',
				'options' => [
					'layout_one' => __('Layout One', 'swiftcart-core'),
					'layout_two' => __('Layout Two', 'swiftcart-core'),
					'layout_three' => __('Layout Three', 'swiftcart-core'),
					'layout_four' => __('Layout Four', 'swiftcart-core'),
				]
			]
		);

		$this->end_controls_section();

		/*
		* Navigation
		*/
		$this->start_controls_section(
			'navigation',
			[
				'label' => __('Navigation', 'swiftcart-core'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'nav_menu',
			[
				'label' => __('Select Nav Menu', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'options' => swiftcart_core_nav_menu(),
				'label_block' => true,
			]
		);
		$this->add_control(
			'cat_menu',
			[
				'label' => __('Select Nav Menu', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'options' => swiftcart_core_nav_menu(),
				'label_block' => true,
			]
		);

		$this->end_controls_section();



		/*
		* Logo
		*/
		$this->start_controls_section(
			'logo_section',
			[
				'label' => __('Logo', 'swiftcart-core'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'logo',
			[
				'label' => __('Image Logo', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'logo_dimension',
			[
				'label' => __('Logo Dimension', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::IMAGE_DIMENSIONS,
				'description' => __('Set Custom Logo Size.', 'swiftcart-core'),
				'default' => [
					'width' => '196',
					'height' => '47',
				],
			]
		);

		$this->end_controls_section();



		/*
		* Menus
		*/
		$this->start_controls_section(
			'header_btns_section',
			[
				'label' => __('Buttons', 'swiftcart-core'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$btns = new \Elementor\Repeater();

		$btns->add_control(
			'icon',
			[
				'label' => esc_html__('Select Icon', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'flaticon-pin',
					'library' => 'swiftcart-icon',
				],
				'label_block' => true,
			]
		);

		$btns->add_control(
			'title',
			[
				'label' => esc_html__('Text', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'placeholder' => esc_html__('Add Text', 'swiftcart-core'),
				'default' =>  wp_kses('Add Text', 'swiftcart-core'),
				'label_block' => true,
			]
		);
		$btns->add_control(
			'url',
			[
				'label' => esc_html__('Url', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => esc_html__('#', 'swiftcart-core'),
				'show_external' => true,
				'default' => [
					'url' => '#',
					'is_external' => false,
					'nofollow' => false,
				],
				'show_label' => false,
			]
		);

		$this->add_control(
			'header_btns',
			[
				'label' => esc_html__('List', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'prevent_empty' => false,
				'fields' => $btns->get_controls(),
				'title_field' => '{{{ text }}}',
				'default' => [
					[
						'text' => esc_html__('Discover', 'swiftcart-core'),
					],
				],
			]
		);
		$this->end_controls_section();

		/*
		* Others
		*/
		$this->start_controls_section(
			'other',
			[
				'label' => __('Other', 'swiftcart-core'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'note',
			[
				'label' => esc_html__('Note Text', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => esc_html__('Welcome to online eCommerce store.', 'swiftcart-core'),
				'label_block' => true,
				'condition'  => [
					'layout_type' => ['layout_two', 'layout_three']
				]
			]
		);

		$this->add_control(
			'search_status',
			[
				'label' => esc_html__('Search Enable ?', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Yes', 'swiftcart-core'),
				'label_off' => esc_html__('No', 'swiftcart-core'),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->add_control(
			'button_label',
			[
				'label' => esc_html__('Button Text', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__('Start Writing', 'swiftcart-core'),
				'label_block' => true,
			]
		);

		$this->add_control(
			'button_url',
			[
				'label' => esc_html__('Button Url', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => esc_html__('#', 'swiftcart-core'),
				'show_external' => true,
				'default' => [
					'url' => '#',
					'is_external' => false,
					'nofollow' => false,
				],
				'show_label' => false,
			]
		);

		$this->add_control(
			'user_status',
			[
				'label' => esc_html__('User Enable ?', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Yes', 'swiftcart-core'),
				'label_off' => esc_html__('No', 'swiftcart-core'),
				'return_value' => 'yes',
				'default' => 'yes',
				'condition'  => [
					'layout_type' => ['layout_two','layout_three']
				]
			]
		);

		$this->add_control(
			'login_url',
			[
				'label' => __('Add Url', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __('#', 'swiftcart-core'),
				'show_external' => true,
				'default' => [
					'url' => '#',
					'is_external' => false,
					'nofollow' => false,
				],
				'show_label' => false,
				'condition'  => [
					'layout_type' => ['layout_two','layout_three']
				]
			]
		);
		$this->add_control(
			'whish_list',
			[
				'label' => esc_html__('User Wishlist ?', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Yes', 'swiftcart-core'),
				'label_off' => esc_html__('No', 'swiftcart-core'),
				'return_value' => 'yes',
				'default' => 'yes',
				'condition'  => [
					'layout_type' => ['layout_two','layout_three']
				]
			]
		);

		$this->add_control(
			'whish_url',
			[
				'label' => __('Wishlist Url', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __('#', 'swiftcart-core'),
				'show_external' => true,
				'default' => [
					'url' => '#',
					'is_external' => false,
					'nofollow' => false,
				],
				'show_label' => false,
				'condition'  => [
					'layout_type' => ['layout_two','layout_three']
				]
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'side_cart',
			[
				'label' => __('Mobile Drawer', 'swiftcart-core'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				'condition'  => [
					'layout_type!' => 'gg'
				]
			]
		);

		$this->add_control(
			'side_logo',
			[
				'label' => __('Image Logo', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_control(
			'side_logo_dimension',
			[
				'label' => __('Logo Dimension', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::IMAGE_DIMENSIONS,
				'description' => __('Set Custom Logo Size.', 'swiftcart-core'),
				'default' => [
					'width' => '158',
					'height' => '48',
				],
			]
		);

		$side_social_icons = new \Elementor\Repeater();

		$side_social_icons->add_control(
			'social_icon',
			[
				'label' => __('Select Icon', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fab fa-facebook',
					'library' => 'brands',
				],
				'label_block' => true,
			]
		);

		$side_social_icons->add_control(
			'social_url',
			[
				'label' => __('Add Url', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __('#', 'swiftcart-core'),
				'show_external' => true,
				'default' => [
					'url' => '#',
					'is_external' => false,
					'nofollow' => false,
				],
				'show_label' => false,
			]
		);

		$this->add_control(
			'side_social_icons',
			[
				'label' => __('Social Icons', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'prevent_empty' => false,
				'fields' => $side_social_icons->get_controls(),
			]
		);

		$side_cta_list = new \Elementor\Repeater();

		$side_cta_list->add_control(
			'icon',
			[
				'label' => esc_html__('Select Icon', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'flaticon-pin',
					'library' => 'swiftcart-icon',
				],
				'label_block' => true,
			]
		);

		$side_cta_list->add_control(
			'text',
			[
				'label' => esc_html__('Text', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'placeholder' => esc_html__('Add Text', 'swiftcart-core'),
				'default' =>  wp_kses('Add Text', 'swiftcart-core'),
				'label_block' => true,
			]
		);


		$this->add_control(
			'side_cta_list',
			[
				'label' => esc_html__('Contact List', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'prevent_empty' => false,
				'fields' => $side_cta_list->get_controls(),
				'title_field' => '{{{ text }}}',
				'default' => [
					[
						'text' => esc_html__('Discover', 'swiftcart-core'),
					],
				],
			]
		);
		$this->end_controls_section();


		/*
		* General style
		*/
		$this->start_controls_section(
			'general_style',
			[
				'label' => esc_html__('Style Options', 'swiftcart-core'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		swiftcart_core_elementor_general_style_options($this, 'Nav Item', '{{WRAPPER}} .header-navigation .ac-nav-menu ul > li > a', ['layout_one', 'layout_two', 'layout_three']);

		$this->add_control(
			'nav_hover_color',
			[
				'label' => esc_html__('Hover Color', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .header-navigation .ac-nav-menu ul > li:hover > a' => 'color: {{VALUE}}',
				],
				'condition' => [
					'layout_type' => ['layout_one', 'layout_two', 'layout_three']
				]
			]
		);

		swiftcart_core_elementor_button_style_options($this, 'Nav Button', '{{WRAPPER}} .ac-header-one__right-btn .ac-header-bnt-2 .theme-btn', '{{WRAPPER}} .ac-header-one__right-btn .ac-header-bnt-2 .theme-btn:hover', ['layout_one', 'layout_two', 'layout_three']);


		$this->end_controls_section();
	}

	/**
	 * Render Elementor widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		include swiftcart_get_template('header-sidecart.php');
		// include swiftcart_get_template('header-search.php');
		include swiftcart_get_template('header-one.php');
		include swiftcart_get_template('header-two.php');
		include swiftcart_get_template('header-three.php');
		include swiftcart_get_template('header-four.php');
	}
}

Plugin::instance()->widgets_manager->register(new Swiftcart_Header_Widget());
