<?php

/**
 * Elementor Widget
 * @package SWIFTCART
 * @since 1.0.0
 */

namespace Elementor;

class Swiftcart_IconBox_Widget extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'swiftcart-icon-box-widget';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__('Icon Box', 'swiftcart-core');
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-product-info';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return ['swiftcart_widgets'];
	}

	/**
	 * Register Elementor widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls() {

		$this->start_controls_section(
			'layout_section',
			[
				'label' => __('Layout', 'swiftcart-core'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout_type',
			[
				'label' => __('Select Layout', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'default' => 'layout_one',
				'options' => [
					'layout_one' => __('Layout One', 'swiftcart-core'),
				]
			]
		);

		$this->end_controls_section();


		/*
		* content Left
		*/
		$this->start_controls_section(
			'content',
			[
				'label' => esc_html__('Content', 'swiftcart-core'),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$infobox = new \Elementor\Repeater();

		$infobox->add_control(
			'bg_color',
			[
				'label' => esc_html__('Bg Color', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::COLOR,
			]
		);

		$infobox->add_control(
			'title',
			[
				'label' => esc_html__('Tab Title', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'label_block' => true,
				'placeholder' => esc_html__('Add Title', 'swiftcart-core'),
				'default' => esc_html__('Add Tab Title', 'swiftcart-core')
			]
		);

		$infobox->add_control(
			'icon',
			[
				'label' => __('Icon', 'swiftcart-addon'),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'far fa-envelope-open',
					'library' => 'swiftcart-icon',
				],
				'label_block' => true,
			]
		);

		$infobox->add_control(
			'content',
			[
				'label' => esc_html__('Info Content', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__('Add Content', 'swiftcart-core'),
				'default' => esc_html__('Add Info Content', 'swiftcart-core')
			]
		);




		$this->add_control(
			'infobox',
			[
				'label' => esc_html__('Info Tab Boxes', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $infobox->get_controls(),
				'default' => [
					[
						'title' => esc_html__('Add Tab Title', 'swiftcart-core')
					],
				],
				'title_field' => '{{{ title }}}',
			]
		);

		$this->end_controls_section();


		//General style
		$this->start_controls_section(
			'general_style',
			[
				'label' => esc_html__('Style Options', 'swiftcart-core'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		swiftcart_core_elementor_general_style_options($this, 'Title', '{{WRAPPER}}  .sw-feature-two__title', ['layout_one']);
		swiftcart_core_elementor_general_style_options($this, 'Summary', '{{WRAPPER}}  .sw-feature-two__info', ['layout_one']);   

		swiftcart_core_elementor_button_style_options($this, 'Icon', '{{WRAPPER}} .sw-feature-two__icon', '{{WRAPPER}} .sw-feature-two__icon:hover', ['layout_one', 'layout_three']);

		$this->end_controls_section();
	}

	/**
	 * Render Elementor widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		include swiftcart_get_template('icon-box-one.php');
	}
}

Plugin::instance()->widgets_manager->register(new Swiftcart_IconBox_Widget());
