<?php

/**
 * Elementor Widget
 * @package SWIFTCART
 * @since 1.0.0
 */

namespace Elementor;

class Swiftcart_News_Letter_Widget extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'swiftcart-news-letter-widget';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__('News Letter', 'swiftcart-core');
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-product-info';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return ['swiftcart_widgets'];
	}

	/**
	 * Register Elementor widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls() {

		$this->start_controls_section(
			'layout_section',
			[
				'label' => __('Layout', 'swiftcart-core'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout_type',
			[
				'label' => __('Select Layout', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'default' => 'layout_one',
				'options' => [
					'layout_one' => __('Layout One', 'swiftcart-core'),
					'layout_two' => __('Layout Two', 'swiftcart-core'),
				]
			]
		);

		$this->end_controls_section();

		/*
		* why subscribe us
		*/
		$this->start_controls_section(
			'why_subscribe_us',
			[
				'label' => esc_html__('Why Subscribe Us', 'swiftcart-core'),
				'tab'   => Controls_Manager::TAB_CONTENT,
				'condition' => [
					'layout_type' => ['layout_one']
				]
			]
		);

		$this->add_control(
			'why_subscribe_us_title',
			[
				'label' => __('Title', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => __('Add Title', 'swiftcart-core'),
			]
		);

		$this->add_control(
			'image',
			[
				'label' => esc_html__('Image', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::MEDIA,

				'default' => [],
			]
		);


		$this->end_controls_section();

		/*
	* newsletter
	*/
		$this->start_controls_section(
			'newsletter',
			[
				'label' => esc_html__('Newsletter', 'swiftcart-core'),
				'tab'   => Controls_Manager::TAB_CONTENT,
				'condition' => [
					'layout_type' => ['layout_one']
				]
			]
		);

		$this->add_control(
			'contact_shortcode',
			[
				'label'       => esc_html__('Choose From Contact Form', 'swiftcart-core'),
				'label_block' => true,
				'type'        => \Elementor\Controls_Manager::SELECT,
				'options'     => swiftcart_core_post_query('wpcf7_contact_form'),
			]
		);

		$this->end_controls_section();
	}

	/**
	 * Render Elementor widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
?>

		<?php if ('layout_one' == $settings['layout_type']) : ?>
			<div class="sw-newsletter-form pt-60 pb-60 sw-has-overlay" data-bg="<?php echo esc_url($settings['image']['url']) ?>">
				<div class="container">
					<div class="sw-newsletter-form__inner">
						<div class="row justify-content-center text-center">
							<div class="col-lg-8">
								<h3 class="sw-newsletter-form__title">Subscribe Newslatter</h3>
								<?php echo str_replace("<br />", "", trim(do_shortcode('[contact-form-7 id="' . $settings['contact_shortcode'] . '" ]'))); ?>
							</div>
						</div>
					</div>
				</div>
			</div>
		<?php endif; ?>
		<?php if ('layout_two' == $settings['layout_type']) : ?>
			<!-- speciality area start -->
			<div class="spaciality-area ">
				<div class="container">
					<div class="row">
						<div class="col-lg-6 mb-5 mb-lg-0">
							<div class="testimonial-area-inner bg-cover h-100" style="background-image: url(<?php echo esc_url(SWIFTCART_CORE_IMG); ?>">
								<?php if (!empty($settings['image']['url'])) : ?>
									<img class="testimonial-right-img" src="<?php echo esc_url($settings['image']['url']); ?>" alt="img">
								<?php endif; ?>
								<div class="single-testimonial-inner style-white">
									<?php if (!empty($settings['why_subscribe_us_title'])) : ?>
										<h4 class="text-white"><?php echo esc_html($settings['why_subscribe_us_title']); ?></h4>
									<?php endif; ?>
									<?php if (!empty($settings['why_subscribe_us_summary'])) : ?>
										<p class="mb-4"><?php echo esc_html($settings['why_subscribe_us_summary']); ?></p>
									<?php endif; ?>
									<?php if (is_array($settings['check_list'])) : ?>
										<ul class="single-list-wrap">
											<?php foreach ($settings['check_list'] as $item) : ?>
												<li class="single-list-inner style-check-box">
													<i class="fa fa-check"></i> <?php echo esc_html($item['title']); ?>
												</li>
											<?php endforeach; ?>
										</ul>
									<?php endif; ?>
								</div>
							</div>
						</div>
						<div class="col-lg-6">
							<div class="subscribe-inner-area h-100" style="background-color: var(--main-color);">
								<?php if (!empty($settings['newsletter_title'])) : ?>
									<h3><?php echo esc_html($settings['newsletter_title']); ?></h3>
								<?php endif; ?>
								<?php if (!empty($settings['newsletter_summary'])) : ?>
									<p><?php echo esc_html($settings['newsletter_summary']); ?></p>
								<?php endif; ?>
								<div class="single-input-inner">
									<?php if (!empty($settings['contact_shortcode'])) : ?>
										<?php echo do_shortcode('[contact-form-7 id="' . $settings['contact_shortcode'] . '" ]'); ?>
									<?php endif; ?>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<!-- speciality area end -->

		<?php endif; ?>

<?php
	}
}

Plugin::instance()->widgets_manager->register_widget_type(new Swiftcart_News_Letter_Widget());
