<?php

/**
 * Elementor Widget
 * @package SWIFTCART
 * @since 1.0.0
 */

namespace Elementor;

class Swiftcart_Offers_Widget extends Widget_Base {

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name() {
        return 'swiftcart-offer-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__('Deals and offers', 'swiftcart-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-product-info';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @since 1.0.0
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories() {
        return ['swiftcart_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function _register_controls() {
        /*
		* Layout
		*/

        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'swiftcart-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'swiftcart-core'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'swiftcart-core'),
                    'layout_two' => __('Layout Two', 'swiftcart-core'),
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'content_coutdown',
            [
                'label' => esc_html__('CountDown Offer', 'swiftcart-core'),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'subtitle',
            [
                'label' => esc_html__('Subtitle', 'swiftcart-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'placeholder' => esc_html__('Add Subtitle', 'swiftcart-core'),
                'default' => esc_html__('Subtitle', 'swiftcart-core'),
                'condition'  => [
                    'layout_type' => 'layout_two'
                ]
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'swiftcart-core'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'label_block' => true,
                'placeholder' => esc_html__('Add Title', 'swiftcart-core'),
                'default' => esc_html__('Deals and offers', 'swiftcart-core')
            ]
        );
        $this->add_control(
            'info',
            [
                'label' => esc_html__('Info', 'swiftcart-core'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'label_block' => true,
                'placeholder' => esc_html__('Add Info', 'swiftcart-core'),
                'default' => esc_html__('Hygiene equipments', 'swiftcart-core')
            ]
        );
        $this->add_control(
            'date',
            [
                'label' => esc_html__('Offer End Date', 'textdomain'),
                'type' => \Elementor\Controls_Manager::DATE_TIME,
            ]
        );

        $this->add_control(
            'button_label',
            [
                'label' => esc_html__('Button Text', 'swiftcart-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Descover', 'swiftcart-core'),
                'label_block' => true,
                'condition'  => [
                    'layout_type' => 'layout_two'
                ]
            ]
        );

        $this->add_control(
            'button_url',
            [
                'label' => esc_html__('Button Url', 'swiftcart-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('#', 'swiftcart-core'),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => false,
                ],
                'show_label' => false,
                'condition'  => [
                    'layout_type' => 'layout_two'
                ]
            ]
        );

        $this->end_controls_section();
        /*
		* content Left
		*/
        $this->start_controls_section(
            'content_offer',
            [
                'label' => esc_html__('Offers Category', 'swiftcart-core'),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
                'condition'  => [
                    'layout_type' => 'layout_one'
                ]
            ]
        );

        $category = new \Elementor\Repeater();

        $category->add_control(
            'image',
            [
                'label' => esc_html__('Category Image', 'swiftcart-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $category->add_control(
            'category',
            [
                'label' => esc_html__('Category Title', 'swiftcart-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'placeholder' => esc_html__('Add Offers Category', 'swiftcart-core'),
                'default' => esc_html__('Laptops', 'swiftcart-core')
            ]
        );

        $category->add_control(
            'url',
            [
                'label' => esc_html__('Category Url', 'swiftcart-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('#', 'swiftcart-core'),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => false,
                ],
                'show_label' => false,
            ]
        );

        $category->add_control(
            'offers',
            [
                'label' => esc_html__('Offers', 'swiftcart-core'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => esc_html__('Add Offers', 'swiftcart-core'),
                'default' => esc_html__('-25%', 'swiftcart-core')
            ]
        );


        $this->add_control(
            'offerlist',
            [
                'label' => esc_html__('Offer List', 'swiftcart-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $category->get_controls(),
                'default' => [
                    [
                        'category' => esc_html__('Add  Category', 'swiftcart-core')
                    ],
                ],
                'title_field' => '{{{ category }}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'images_section',
            [
                'label' => esc_html__('Images', 'swiftcart-core'),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
                'condition'  => [
                    'layout_type' => 'layout_two'
                ]
            ]
        );

        $this->add_control(
            'image',
            [
                'label' => esc_html__('Image', 'swiftcart-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'shape',
            [
                'label' => esc_html__('Shape', 'swiftcart-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [],
            ]
        );
        $this->add_control(
            'border_shape',
            [
                'label' => esc_html__('Shape Border', 'swiftcart-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [],
            ]
        );


        $this->end_controls_section();

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Style Options', 'swiftcart-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        swiftcart_core_elementor_general_style_options($this, 'Sub Title', '{{WRAPPER}} .sw-ads-countdown__subtitle', ['layout_one', 'layout_two']);
        swiftcart_core_elementor_general_style_options($this, 'Title', '{{WRAPPER}} .sw-offer-one__title,{{WRAPPER}} .sw-offer-one__cat-title,{{WRAPPER} .sw-ads-countdown__title', ['layout_one', 'layout_two']);
        swiftcart_core_elementor_general_style_options($this, 'Info', '{{WRAPPER}} .sw-oofer-one__info, {{WRAPPER} .sw-ads-countdown__info', ['layout_one', 'layout_two']);
        swiftcart_core_elementor_general_style_options($this, 'Counter', '{{WRAPPER}} .sw-offer-one__countdown-inner ul li,{{WRAPPER}} .sw-ads-countdown__count-inner ul li span', ['layout_one']);
        swiftcart_core_elementor_link_style_options($this, 'Button', '{{WRAPPER}} .swiftcart-btn-black', '{{WRAPPER}} .swiftcart-btn-black:hover', ['layout_two']);

        $this->end_controls_section();
    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        include swiftcart_get_template('offer-one.php');
        include swiftcart_get_template('offer-two.php');
    }
}

Plugin::instance()->widgets_manager->register(new Swiftcart_Offers_Widget());
