<?php

/**
 * Elementor Widget
 * @package SWIFTCART
 * @since 1.0.0
 */

namespace Elementor;

class Swiftcart_Portfolio_Details_Widget extends Widget_Base
{

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name()
	{
		return 'swiftcart-portfolio-details-widget';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title()
	{
		return esc_html__('Portfolio Details', 'swiftcart-core');
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon()
	{
		return 'eicon-product-info';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories()
	{
		return ['swiftcart_widgets'];
	}

	/**
	 * Register Elementor widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls()
	{

		$this->start_controls_section(
			'layout_section',
			[
				'label' => __('Layout', 'swiftcart-core'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout_type',
			[
				'label' => __('Select Layout', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'default' => 'portfolio_thumbnail',
				'options' => [
					'layout_one' => __('layout_one', 'swiftcart-core'),
				]
			]
		);


		$this->end_controls_section();


		/*
		* Details Left Side
		*/
		$this->start_controls_section(
			'details_left',
			[
				'label' => esc_html__('Portfolio Left', 'swiftcart-core'),
				'tab'   => Controls_Manager::TAB_CONTENT,
				'condition'  => [
					'layout_type' => 'layout_one'
				]
			]
		);

		$details_left_list = new \Elementor\Repeater();

		$details_left_list->add_control(
			'title',
			[
				'label' => esc_html__('Title', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'placeholder' => esc_html__('Add Title', 'swiftcart-core'),
				'default' => esc_html__('Add Title', 'swiftcart-core'),
				'label_block' => true,
			]
		);

		$this->add_control(
			'details_left_list',
			[
				'label' => esc_html__('Details List', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $details_left_list->get_controls(),
				'prevent_empty' => false,
				'title_field' => '{{{ title }}}',
				'default' => [
					[
						'title' => esc_html__('Add Title', 'swiftcart-core')
					],
				],
			]
		);
		$this->add_control(
			'summary',
			[
				'label' => esc_html__('summary', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__('Add summary', 'swiftcart-core'),
				'default' => esc_html__('Add summary', 'swiftcart-core'),
			]
		);

		$this->add_control(
			'tag_title',
			[
				'label' => esc_html__('Title', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__('Add Title', 'swiftcart-core'),
				'default' => esc_html__('Add Title'),
			]
		);
		$this->add_control(
			'tag',
			[
				'label' => esc_html__('', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__('Add Title', 'swiftcart-core'),
				'default' => esc_html__('Homeless, Donation, African, Education', 'swiftcart-core', 'swiftcart-core'),
			]
		);

		$donation_list = new \Elementor\Repeater();

		$donation_list->add_control(
			'title',
			[
				'label' => esc_html__('Title', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'placeholder' => esc_html__('Add Title', 'swiftcart-core'),
				'default' => esc_html__('Add Title', 'swiftcart-core'),
				'label_block' => true,
			]
		);
		$donation_list->add_control(
			'doantion',
			[
				'label' => esc_html__('info', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'placeholder' => esc_html__('Add info', 'swiftcart-core'),
				'default' => esc_html__('Add info', 'swiftcart-core'),
				'label_block' => true,
			]
		);

		$this->add_control(
			'donar_list',
			[
				'label' => esc_html__('Donation List', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $donation_list->get_controls(),
				'prevent_empty' => false,
				'title_field' => '{{{ title }}}',
				'default' => [
					[
						'title' => esc_html__('Add Title', 'swiftcart-core')
					],
				],
			]
		);

		$this->end_controls_section();



		/*
		* Details Right Side
		*/
		$this->start_controls_section(
			'details_right',
			[
				'label' => esc_html__('Video', 'swiftcart-core'),
				'tab'   => Controls_Manager::TAB_CONTENT,
				'condition'  => [
					'layout_type' => 'layout_one'
				]
			]
		);

		$this->add_control(
			'video_url',
			[
				'label' => esc_html__('Video Url', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => esc_html__('#', 'swiftcart-core'),
				'default' => [
					'url' => 'https://www.youtube.com/embed/Wimkqo8gDZ0',
				],
				'show_label' => false,
			]
		);


		$this->add_control(
			'video_thumb',
			[
				'label' => __('Video Image', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				]
			]
		);

		$this->end_controls_section();



		//General style
		$this->start_controls_section(
			'general_style',
			[
				'label' => esc_html__('Style Options', 'swiftcart-core'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->end_controls_section();
	}

	/**
	 * Render Elementor widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render()
	{
		$settings = $this->get_settings_for_display();
		include swiftcart_get_template('portfolio-details_one.php');
	}
}

Plugin::instance()->widgets_manager->register(new Swiftcart_Portfolio_Details_Widget());
