<?php

/**
 * Elementor Widget
 * @package SWIFTCART
 * @since 1.0.0
 */

namespace Elementor;

class Swiftcart_Portfolio_Widget extends Widget_Base
{

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name()
	{
		return 'swiftcart-Portfolio-widget';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title()
	{
		return esc_html__('Portfolio', 'swiftcart-core');
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon()
	{
		return 'eicon-product-info';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories()
	{
		return ['swiftcart_widgets'];
	}

	/**
	 * Register Elementor widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls()
	{

		$this->start_controls_section(
			'layout_section',
			[
				'label' => __('Layout', 'swiftcart-core'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout_type',
			[
				'label' => __('Select Layout', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'default' => 'layout_one',
				'options' => [
					'layout_one' => __('Layout One', 'swiftcart-core'),
				]
			]
		);


		$this->end_controls_section();


		/*
		* Portfolio Right Side
		*/
		$this->start_controls_section(
			'portfolio_btn',
			[
				'label' => esc_html__('Portfolio Button', 'swiftcart-core'),
				'tab'   => Controls_Manager::TAB_CONTENT,
				'condition'  => [
					'layout_type' => 'layout_one'
				]
			]
		);

		$portfolio_button = new \Elementor\Repeater();

		$portfolio_button->add_control(
			'button_label',
			[
				'label' => esc_html__('Button', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'placeholder' => esc_html__('Add Button', 'swiftcart-core'),
				'default' => esc_html__('Button', 'swiftcart-core'),
				'label_block' => true,
			]
		);

		$portfolio_button->add_control(
			'slug',
			[
				'label' => esc_html__('slug', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'placeholder' => esc_html__('Add slug', 'swiftcart-core'),
				'default' => esc_html__('Add slug', 'swiftcart-core'),
			]
		);
		$this->add_control(
			'portfolio_button',
			[
				'label' => esc_html__('Portfolio Button', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $portfolio_button->get_controls(),
				'prevent_empty' => false,
				'title_field' => '{{{ title }}}',
				'default' => [
					[
						'title' => esc_html__('item1', 'swiftcart-core')
					],
					[
						'title' => esc_html__('item2', 'swiftcart-core')
					],
				],
			]
		);


		$this->end_controls_section();


		/*
		* Portfolio Left Side
		*/
		$this->start_controls_section(
			'portfolio_left',
			[
				'label' => esc_html__('Portfolio Item', 'swiftcart-core'),
				'tab'   => Controls_Manager::TAB_CONTENT,
				'condition'  => [
					'layout_type' => 'layout_one'
				]
			]
		);

		$portfolio_left_list = new \Elementor\Repeater();

		$portfolio_left_list->add_control(
			'slugs',
			[
				'label' => esc_html__('slugs', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__('Add Summary', 'swiftcart-core'),
				'default' => esc_html__('slug_one slug_two', 'swiftcart-core'),
			]
		);

		$portfolio_left_list->add_control(
			'title',
			[
				'label' => esc_html__('Title', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'placeholder' => esc_html__('Add Title', 'swiftcart-core'),
				'default' => esc_html__('Add Title', 'swiftcart-core'),
				'label_block' => true,
			]
		);

		$portfolio_left_list->add_control(
			'tagline',
			[
				'label' => esc_html__('Tagline', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__('Add Tagline', 'swiftcart-core'),
				'default' => esc_html__('Add Tagline', 'swiftcart-core'),
			]
		);

		$portfolio_left_list->add_control(
			'icon',
			[
				'label' => __('Arrow Icon One', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'flaticon-chevron',
					'library' => 'swiftcart-icon',
				],
				'label_block' => true,
			]
		);

		$portfolio_left_list->add_control(
			'url',
			[
				'label' => esc_html__('Button Url', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => esc_html__('#', 'swiftcart-core'),
				'show_external' => true,
				'default' => [
					'url' => '#',
					'is_external' => false,
					'nofollow' => false,
				],
				'show_label' => false,
			]
		);

		$portfolio_left_list->add_control(
			'thumb',
			[
				'label' => __('Thumbnail', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'portfolio_list',
			[
				'label' => esc_html__('Portfolio List', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $portfolio_left_list->get_controls(),
				'prevent_empty' => false,
				'title_field' => '{{{ title }}}',
				'default' => [
					[
						'title' => esc_html__('Add Title', 'swiftcart-core')
					],
				],
			]
		);

		$this->end_controls_section();
		//General style
		$this->start_controls_section(
			'general_style',
			[
				'label' => esc_html__('Style Options', 'swiftcart-core'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		swiftcart_core_elementor_general_style_options($this, 'Feature Left Title', '{{WRAPPER}} .feature-single-slide .section-title h3', ['layout_one']);
		swiftcart_core_elementor_general_style_options($this, 'Feature Left Sub Title', '{{WRAPPER}} .feature-single-slide .section-title p', ['layout_one']);

		swiftcart_core_elementor_button_style_options($this, 'Feature Left Button', '{{WRAPPER}} .feature-single-slide .btn', '{{WRAPPER}} .feature-single-slide .btn:hover', ['layout_one']);


		swiftcart_core_elementor_general_style_options($this, 'Feature Right Title', '{{WRAPPER}} .section-title .section-title__subtitle', ['layout_one']);
		swiftcart_core_elementor_general_style_options($this, 'Feature Right Sub Title', '{{WRAPPER}} .section-title h2', ['layout_one']);
		swiftcart_core_elementor_general_style_options($this, 'Feature Right Content', '{{WRAPPER}} .section-title p', ['layout_one']);

		swiftcart_core_elementor_general_style_options($this, 'Feature Right Slider Title', '{{WRAPPER}} .feature-item h4', ['layout_one']);
		swiftcart_core_elementor_general_style_options($this, 'Feature Right Slider Summary', '{{WRAPPER}} .feature-item p', ['layout_one']);

		swiftcart_core_elementor_general_style_options($this, 'Feature Title', '{{WRAPPER}} .feature-three-content-part .section-title h2', ['layout_three']);
		swiftcart_core_elementor_general_style_options($this, 'Feature Sub Title', '{{WRAPPER}} .section-title .section-title__subtitle', ['layout_three']);

		swiftcart_core_elementor_general_style_options($this, 'Feature List Title', '{{WRAPPER}} .feature-item--two a, {{WRAPPER}} .feature-item--three a', ['layout_two', 'layout_three']);
		swiftcart_core_elementor_general_style_options($this, 'Feature List Summary', '{{WRAPPER}} .feature-item--two p, {{WRAPPER}} .feature-item--three .feature-item__content p', ['layout_two', 'layout_three']);
		swiftcart_core_elementor_general_style_options($this, 'Feature Icon', '{{WRAPPER}} .feature-item--two .feature-item__icon i, {{WRAPPER}} .feature-item--three .feature-item__icon i', ['layout_two', 'layout_three']);

		swiftcart_core_elementor_button_style_options($this, 'Button', '{{WRAPPER}} .feature-item--two .feature-item__btn', '{{WRAPPER}} .feature-item--two .feature-item__btn:hover', ['layout_two']);

		$this->end_controls_section();
	}

	/**
	 * Render Elementor widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render()
	{
		$settings = $this->get_settings_for_display();
		include swiftcart_get_template('portfolio-one.php');
	}
}

Plugin::instance()->widgets_manager->register(new Swiftcart_Portfolio_Widget());
