<?php

/**
 * Elementor Widget
 * @package SWIFTCART
 * @since 1.0.0
 */

namespace Elementor;

class Swiftcart_Pricing_Widget extends Widget_Base
{

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name()
	{
		return 'swiftcart-pricing-widget';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title()
	{
		return esc_html__('Pricing', 'swiftcart-core');
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon()
	{
		return 'eicon-product-info';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories()
	{
		return ['swiftcart_widgets'];
	}

	/**
	 * Register Elementor widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls()
	{

		$this->start_controls_section(
			'layout_section',
			[
				'label' => __('Layout', 'swiftcart-core'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout_type',
			[
				'label' => __('Select Layout', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'default' => 'layout_one',
				'options' => [
					'layout_one' => __('Layout One', 'swiftcart-core'),
					'layout_two' => __('Layout Two', 'swiftcart-core'),
					'layout_three' => __('Layout Three', 'swiftcart-core'),
					'layout_four' => __('Layout Three', 'swiftcart-core'),
				]
			]
		);

		$this->end_controls_section();

		include  swiftcart_get_elementor_option('pricing-one-option.php'); //layout one,two,four
		include  swiftcart_get_elementor_option('pricing-three-option.php');

		//General style
		$this->start_controls_section(
			'general_style',
			[
				'label' => esc_html__('Section Header Style', 'swiftcart-core'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		swiftcart_core_elementor_general_style_options($this, 'Sec Title', '{{WRAPPER}} .section-title h2', ['layout_one', 'layout_two', 'layout_three', 'layout_four']);
		swiftcart_core_elementor_general_style_options($this, 'Sec Sub Title', '{{WRAPPER}} .sub-title.style-one,{{WRAPPER}} .sub-title', ['layout_one', 'layout_two', 'layout_three', 'layout_four']);

		swiftcart_core_elementor_general_style_options($this, 'Sec Summary', '{{WRAPPER}} .section-title p', ['layout_one', 'layout_two', 'layout_three', 'layout_four']);

		swiftcart_core_elementor_button_style_options($this, 'Button', '{{WRAPPER}} .pricing-wrapper.black-dark-bg .pricing-tabs .nav-link,.home-two .pricing-tabs .nav-link', '{{WRAPPER}} .pricing-wrapper.black-dark-bg .pricing-tabs .nav-link:hover,.home-two .pricing-tabs .nav-link:hover', ['layout_one', 'layout_four']);

		$this->end_controls_section();

		//General style
		$this->start_controls_section(
			'price_style',
			[
				'label' => esc_html__('Price Style', 'swiftcart-core'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		swiftcart_core_elementor_general_style_options($this, 'Title', '{{WRAPPER}} .pricing-item.style-one .pricing-head span,{{WRAPPER}} .pricing-item.style-three .pricing-head span.package,{{WRAPPER}} .pricing-item.style-two .pricing-head span.package', ['layout_one', 'layout_two', 'layout_three', 'layout_four']);

		swiftcart_core_elementor_button_style_options($this, 'Price Button', '{{WRAPPER}} .theme-btn.style-two, {{WRAPPER}} .pricing-item.style-three .pricing-button .theme-btn.style-two', '{{WRAPPER}} .theme-btn.style-two:hover,{{WRAPPER}} .pricing-item.style-three .pricing-button .theme-btn.style-two:hover,{{WRAPPER}} .pricing-item.style-two .pricing-button .theme-btn:hover', ['layout_one', 'layout_two', 'layout_three', 'layout_four']);

		swiftcart_core_elementor_general_style_options($this, 'Price', '{{WRAPPER}} .pricing-item.style-one .pricing-head h3 span.currency, .pricing-item.style-three .pricing-head h3 span.currency,{{WRAPPER}} .pricing-item.style-two .pricing-head h3', ['layout_one', 'layout_two', 'layout_three', 'layout_four']);

		swiftcart_core_elementor_general_style_options($this, 'List', '{{WRAPPER}} .check-list.style-one li', ['layout_one', 'layout_two', 'layout_three', 'layout_four']);

		$this->end_controls_section();
	}

	/**
	 * Render Elementor widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render()
	{
		$settings = $this->get_settings_for_display();

		include swiftcart_get_template('pricing-one.php');
		include swiftcart_get_template('pricing-two.php');
		include swiftcart_get_template('pricing-three.php');
		include swiftcart_get_template('pricing-four.php');
	}
}

Plugin::instance()->widgets_manager->register(new Swiftcart_Pricing_Widget());
