<?php

/**
 * Elementor Widget
 * @package SWIFTCART
 * @since 1.0.0
 */

namespace Elementor;

class Swiftcart_Product_Category_Widget extends Widget_Base {

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name() {
        return 'swiftcart-product-category';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__('Product Categories', 'swiftcart-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-product-info';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @since 1.0.0
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories() {
        return ['swiftcart_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function _register_controls() {

        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'swiftcart-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'swiftcart-core'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'swiftcart-core'),
                    'layout_two' => __('Layout Two', 'swiftcart-core'),
                    // 'layout_three' => __('Layout Three', 'swiftcart-core'),
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'content',
            [
                'label' => esc_html__('Content', 'swiftcart-core'),
                'tab'   => Controls_Manager::TAB_CONTENT,
                'condition'  => [
                    'layout_type' => ['layout_one'],
                ]
            ]
        );

        $this->add_control(
            'product_count',
            [
                'label' => esc_html__('Show Product Count', 'swiftcart-core'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'swiftcart-core'),
                'label_off' => esc_html__('Hide', 'swiftcart-core'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'show_empty_category',
            [
                'label' => esc_html__('Show Empty Category', 'swiftcart-core'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'swiftcart-core'),
                'label_off' => esc_html__('Hide', 'swiftcart-core'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'category_list',
            [
                'label' => esc_html__('Category List', 'swiftcart-core'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'label_block' => true,
                'multiple' => true,
                'options' => swiftcart_core_taxonomy_list('product_cat'),

            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'content_two',
            [
                'label' => esc_html__('Content', 'swiftcart-core'),
                'tab'   => Controls_Manager::TAB_CONTENT,
                'condition'  => [
                    'layout_type' => ['layout_two'],
                ]
            ]
        );

        $this->add_control(
            'image',
            [
                'label' => esc_html__('Image', 'swiftcart-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $features_list = new \Elementor\Repeater();

        $features_list->add_control(
            'image',
            [
                'label' => esc_html__('Image', 'swiftcart-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    // 'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $features_list->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'swiftcart-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('Add Title', 'swiftcart-core'),
                'default' => esc_html__('Add Title', 'swiftcart-core'),
                'label_block' => true,
            ]
        );
        $features_list->add_control(
            'url',
            [
                'label' => esc_html__('Url', 'swiftcart-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('#', 'swiftcart-core'),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => false,
                ],
                'show_label' => false,
            ]
        );
        $features_list->add_control(
            'info',
            [
                'label' => esc_html__('Info', 'swiftcart-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('Add Info', 'swiftcart-core'),
                'default' => esc_html__('Add Info', 'swiftcart-core'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'features_list',
            [
                'label' => esc_html__('Features List', 'swiftcart-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $features_list->get_controls(),
                'prevent_empty' => false,
                'title_field' => '{{{ title }}}',
                'default' => [
                    [
                        'title' => esc_html__('Add Title', 'swiftcart-core')
                    ],
                ],
            ]
        );

        $this->end_controls_section();

        //General stylep
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Style Options', 'swiftcart-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        swiftcart_core_elementor_link_style_options($this, 'Category Name', '{{WRAPPER}} .el-cat-name', '{{WRAPPER}} .el-cat-name a:hover', ['layout_one', 'layout_two', 'layout_three']);




        $this->end_controls_section();

        swiftcart_core_get_elementor_carousel_options($this, ['layout_one']);
    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        include swiftcart_get_template('product-category-one.php');
        include swiftcart_get_template('product-category-two.php');
        // include swiftcart_get_template('how-it-work-three.php');
    }
}

Plugin::instance()->widgets_manager->register(new Swiftcart_Product_Category_Widget());
