<?php

/**
 * Elementor Widget
 * @package SWIFTCART
 * @since 1.0.0
 */

namespace Elementor;

class Swiftcart_Produc_List_Widget extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'swiftcart-product-list-widget';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__('Product List', 'swiftcart-core');
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-product-info';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return ['swiftcart_widgets'];
	}

	/**
	 * Register Elementor widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls() {

		$this->start_controls_section(
			'layout_section',
			[
				'label' => __('Layout', 'swiftcart-core'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout_type',
			[
				'label' => __('Select Layout', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'default' => 'layout_one',
				'options' => [
					'layout_one' => __('Layout One', 'swiftcart-core'),
					'layout_two' => __('Layout Two', 'swiftcart-core'),
					'layout_three' => __('Layout Three', 'swiftcart-core'),
					'layout_four' => __('Layout Four', 'swiftcart-core'),
					'layout_five' => __('Layout Five', 'swiftcart-core'),
					'layout_six' => __('Layout Six', 'swiftcart-core'),
					'layout_seven' => __('Layout Seven', 'swiftcart-core'),
					'layout_eight' => __('Layout Eight', 'swiftcart-core'),
					'layout_nine' => __('Layout Nine', 'swiftcart-core'),
				]
			]
		);

		$this->end_controls_section();

		/*
		* content
		*/
		$this->start_controls_section(
			'content',
			[
				'label' => esc_html__('Content', 'swiftcart-core'),
				'tab'   => Controls_Manager::TAB_CONTENT,
				'condition'  => [
					'layout_type!' => ['layout_four','layout_nine'],
				]
			]
		);
		$this->add_control(
			'heading_status',
			[
				'label' => __('Enable Title ?', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __('Yes', 'swiftcart-core'),
				'label_off' => __('No', 'swiftcart-core'),
				'return_value' => 'yes',
				'default' => 'yes',
				'condition'  => [
					'layout_type' => ['layout_one'],
				]

			]
		);
		$this->add_control(
			'banner_status',
			[
				'label' => __('Enable Banner ?', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __('Yes', 'swiftcart-core'),
				'label_off' => __('No', 'swiftcart-core'),
				'return_value' => 'yes',
				'default' => 'yes',
				'condition'  => [
					'layout_type' => ['layout_two', 'layout_three', 'layout_five', 'layout_eight']
				]
			]
		);
		$this->add_control(
			'banner_image',
			[
				'label' => esc_html__('Banner Image', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'condition'  => [
					'layout_type' => ['layout_two', 'layout_three', 'layout_five', 'layout_eight'],
					'banner_status' => ['yes']
				]
			]
		);
		$this->add_control(
			'title',
			[
				'label' => __('Title', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => __('Add Title', 'swiftcart-core'),
				'default' => __('Add Title', 'swiftcart-core'),
				'condition'  => [
					'layout_type!' => ['layout_five'],
				]
			]
		);
		$this->add_control(
			'info',
			[
				'label' => __('Info', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => __('Add Info', 'swiftcart-core'),
				'default' => __('Add Info', 'swiftcart-core'),
				'condition'  => [
					'layout_type' => ['layout_two', 'layout_three'],
					'banner_status' => ['yes']
				]
			]
		);
		$this->add_control(
			'price',
			[
				'label' => __('Price', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => __('Add Price', 'swiftcart-core'),
				'default' => __('Add Price', 'swiftcart-core'),
				'condition'  => [
					'layout_type' => ['layout_two'],
					'banner_status' => ['yes']
				]
			]
		);
		$this->add_control(
			'subtitle',
			[
				'label' => __('Price', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => __('Add Price', 'swiftcart-core'),
				'default' => __('Add Price', 'swiftcart-core'),
				'condition'  => [
					'layout_type' => ['layout_three'],
					'banner_status' => ['yes']
				]
			]
		);

		$this->add_control(
			'date',
			[
				'label' => esc_html__('Offer End Date', 'textdomain'),
				'type' => \Elementor\Controls_Manager::DATE_TIME,
				'condition'  => [
					'layout_type' => ['layout_three'],
					'banner_status' => ['yes']
				]
			]
		);

		$this->add_control(
			'button_label',
			[
				'label' => esc_html__('Button Text', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__('Descover', 'swiftcart-core'),
				'label_block' => true,
				'condition'  => [
					'layout_type' => ['layout_two', 'layout_three', 'layout_eight'],
					'banner_status' => ['yes']
				]
			]
		);

		$this->add_control(
			'button_url',
			[
				'label' => esc_html__('Button Url', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => esc_html__('#', 'swiftcart-core'),
				'show_external' => true,
				'default' => [
					'url' => '#',
					'is_external' => false,
					'nofollow' => false,
				],
				'show_label' => false,
				'condition'  => [
					'layout_type' => ['layout_two', 'layout_three', 'layout_eight'],
					'banner_status' => ['yes']
				]
			]
		);

		$this->end_controls_section();
		//post options

		$this->start_controls_section(
			'post_options',
			[
				'label' => esc_html__('Product Options', 'swiftcart-core'),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'post_count',
			[
				'label' => __('Number Of Products', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => ['count'],
				'range' => [
					'count' => [
						'min' => 0,
						'max' => 15,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'count',
					'size' => 6,
				],
			]
		);
		$this->add_control(
			'post_title_count',
			[
				'label' => __('Title Character Limit', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => ['count'],
				'range' => [
					'count' => [
						'min' => 0,
						'max' => 400,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'count',
					'size' => 15,
				],
			]
		);
		$this->add_control(
			'word_limit',
			[
				'label' => __('Word Limit', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => ['count'],
				'range' => [
					'count' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'count',
					'size' => 15,
				],
			]
		);
		$this->add_control(
			'select_cat',
			[
				'label'    => esc_html__('Select Category', 'swiftcart-core'),
				'type'     => Controls_Manager::SELECT2,
				'multiple' => true,
				'options'  => swiftcart_core_post_tag('product_cat'),

			]
		);
		$this->add_control(
			'exclude_cat',
			[
				'label'    => esc_html__('Exclude Category', 'swiftcart-core'),
				'type'     => Controls_Manager::SELECT2,
				'multiple' => true,
				'options'  => swiftcart_core_taxonomy_list('product_cat'),
			]
		);
		// $this->add_control(
		// 	'select_tag',
		// 	[
		// 		'label'    => esc_html__('Select Tag', 'swiftcart-core'),
		// 		'type'     => Controls_Manager::SELECT2,
		// 		'multiple' => true,
		// 		'options'  => swiftcart_core_taxonomy_list('product_tag'),
		// 	]
		// );

		$this->add_control(
			'product_type',
			[
				'label'         => __('Product Type', 'cannabo'),
				'type'             => Controls_Manager::SELECT,
				'label_block'   => true,
				'options'         => [
					''                => __('Select Product Type', 'cannabo'),
					'recent-items'     => __('Recent', 'cannabo'),
					'top-rated'      => __('Top Rated', 'cannabo'),
					'featured'         => __('Featured', 'cannabo'),
					'on-sale'         => __('On Sale', 'cannabo'),
					'best-selling'     => __('Best Selling', 'cannabo'),
				],
				'default'        => 'recent-items'
			]
		);

		$this->add_control(
			'pagination_status',
			[
				'label' => __('Enable Pagination?', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __('Yes', 'swiftcart-core'),
				'label_off' => __('No', 'swiftcart-core'),
				'return_value' => 'yes',
				'default' => 'no',
				'condition' => [
					'layout_type' => ['layout_seven']
				]

			]
		);

		$this->end_controls_section();



		//General style
		$this->start_controls_section(
			'general_style',
			[
				'label' => esc_html__('Section Header Style', 'swiftcart-core'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				'condition' => [
					'layout_type' => ['layout_one', 'layout_two']
				]
			]
		);

		swiftcart_core_elementor_general_style_options($this, 'Title', '{{WRAPPER}} .el-sec-title', ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_five']);
		swiftcart_core_elementor_general_style_options($this, 'Sub Title', '{{WRAPPER}} .el-sec-subtitle', ['layout_two', 'layout_three', 'layout_four', 'layout_five']);
		swiftcart_core_elementor_button_style_options($this, 'Banner Button', '{{WRAPPER}} .swiftcart-btn', '{{WRAPPER}} {{WRAPPER}} .btn-base:hover', ['layout_two']);

		$this->end_controls_section();

		//post style
		$this->start_controls_section(
			'post_style',
			[
				'label' => esc_html__('Product Style', 'swiftcart-core'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		swiftcart_core_elementor_link_style_options($this, 'Product Title', '{{WRAPPER}} .el-pd-title', '{{WRAPPER}} 
		.el-pd-title a:hover', ['layout_one', 'layout_three', 'layout_four']);
		swiftcart_core_elementor_general_style_options($this, 'Product Price', '{{WRAPPER}} .el-pd-price', ['layout_one', 'layout_three', 'layout_four']);
		swiftcart_core_elementor_general_style_options($this, 'Product Summary', '{{WRAPPER}} .el-pd-summary', ['layout_three']);

		swiftcart_core_elementor_general_style_options($this, 'Product Ratting', '{{WRAPPER}} .el-pd-ratting, {{WRAPPER}} .el-pd-ratting i', ['layout_two', 'layout_three']);

		swiftcart_core_elementor_button_style_options($this, 'Button', '{{WRAPPER}} .single-product-wrap.style-bottom-radius .product-details-inner .read-more,{{WRAPPER}} .btn-base', '{{WRAPPER}} .single-product-wrap.style-bottom-radius .product-details-inner .read-more:hover, {{WRAPPER}} .btn-base:hover', ['1']);



		$this->end_controls_section();
	}
 
	/**
	 * Render Elementor widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();


		include swiftcart_get_template('product-list-one.php');
		include swiftcart_get_template('product-list-two.php');
		include swiftcart_get_template('product-list-three.php');
		include swiftcart_get_template('product-list-four.php');
		include swiftcart_get_template('product-list-five.php');
		include swiftcart_get_template('product-list-six.php');
		include swiftcart_get_template('product-list-seven.php');
		include swiftcart_get_template('product-list-eight.php');
		include swiftcart_get_template('product-list-nine.php');
	}
}

Plugin::instance()->widgets_manager->register(new Swiftcart_Produc_List_Widget());
    