<?php

/**
 * Elementor Widget
 * @package SWIFTCART
 * @since 1.0.0
 */

namespace Elementor;

class Swiftcart_Property_Categores_Widget extends Widget_Base
{

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name()
	{
		return 'swiftcart-property-categores-widget';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title()
	{
		return esc_html__('Property Categores', 'swiftcart-core');
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon()
	{
		return 'eicon-product-info';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories()
	{
		return ['swiftcart_widgets'];
	}

	/**
	 * Register Elementor widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls()
	{

		$this->start_controls_section(
			'layout_section',
			[
				'label' => __('Layout', 'swiftcart-core'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout_type',
			[
				'label' => __('Select Layout', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'default' => 'layout_one',
				'options' => [
					'layout_one' => __('Layout One', 'swiftcart-core'),
					'layout_two' => __('Layout Two', 'swiftcart-core'),
					'layout_three' => __('Layout Three', 'swiftcart-core'),
					// 'layout_four' => __('Layout Four', 'swiftcart-core'),
				]
			]
		);

		$this->end_controls_section();

		/*
		* content
		*/
		$this->start_controls_section(
			'content',
			[
				'label' => esc_html__('Content', 'swiftcart-core'),
				'tab'   => Controls_Manager::TAB_CONTENT,
				'condition' => [
					'layout_type' => ['layout_one', 'layout_two', 'layout_three']
				]
			]
		);
		$this->add_control(
			'heading_status',
			[
				'label' => __('Enable Heading?', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __('Yes', 'swiftcart-core'),
				'label_off' => __('No', 'swiftcart-core'),
				'return_value' => 'yes',
				'default' => 'yes',
				'condition' => [
					'layout_type' => ['layout_one']
				]

			]
		);
		$this->add_control(
			'title',
			[
				'label' => __('Title', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => __('Add Title', 'swiftcart-core'),
				'default' => __('Add Title', 'swiftcart-core'),
			]
		);

		$this->add_control(
			'sub_title',
			[
				'label' => __('Sub Title', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => __('Add Sub Title', 'swiftcart-core'),
				'default' => __('Add Sub Title', 'swiftcart-core'),
			]
		);



		$this->add_control(
			'blog_shape',
			[
				'label' => __('Icon Background Shape', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'condition' => [
					'layout_type' => ['gg']
				]
			]
		);

		$this->end_controls_section();

		//post options
		$this->start_controls_section(
			'post_options',
			[
				'label' => esc_html__('Category Options', 'swiftcart-core'),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'cat_count',
			[
				'label' => __('Number Of Categores', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => ['count'],
				'range' => [
					'count' => [
						'min' => 0,
						'max' => 15,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'count',
					'size' => 5,
				],
			]
		);




		$this->end_controls_section();

		//General style
		$this->start_controls_section(
			'general_style',
			[
				'label' => esc_html__('Section Header Style', 'swiftcart-core'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				'condition' => [
					'layout_type' => ['layout_one', 'layout_two']
				]
			]
		);

		swiftcart_core_elementor_general_style_options($this, 'Title', '{{WRAPPER}} .section-title h2', ['layout_one', 'layout_two']);
		swiftcart_core_elementor_general_style_options($this, 'Sub Title', '{{WRAPPER}} .section-title h6', ['layout_one', 'layout_two']);

		$this->end_controls_section();

		//Category style
		$this->start_controls_section(
			'category_style',
			[
				'label' => esc_html__('Category Style', 'swiftcart-core'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		swiftcart_core_elementor_link_style_options($this, 'Category Title', '{{WRAPPER}} .single-category-product-wrap .single-category-product-details h4', '{{WRAPPER}} .single-category-product-wrap .single-category-product-details h4 a:hover', ['layout_one', 'layout_two', 'layout_three', 'layout_four']);

		swiftcart_core_elementor_button_style_options($this, 'Category Meta', '{{WRAPPER}} .btn-base', '{{WRAPPER}} .btn-base:hover', ['layout_one', 'layout_two', 'layout_three', 'layout_four']);



		$this->end_controls_section();
	}

	/**
	 * Render Elementor widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render()
	{
		$settings = $this->get_settings_for_display();


		include swiftcart_get_template('property-categores-one.php');
		include swiftcart_get_template('property-categores-two.php');
		include swiftcart_get_template('property-categores-three.php');
		// include swiftcart_get_template('blog-four.php');
	}
}

Plugin::instance()->widgets_manager->register(new Swiftcart_Property_Categores_Widget());
