<?php

/**
 * Elementor Widget
 * @package SWIFTCART
 * @since 1.0.0
 */

namespace Elementor;

class Swiftcart_Property_Details_Widget extends Widget_Base
{

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name()
	{
		return 'swiftcart-property-details-widget';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title()
	{
		return esc_html__('Property Details', 'swiftcart-core');
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon()
	{
		return 'eicon-product-info';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories()
	{
		return ['swiftcart_widgets'];
	}

	/**
	 * Register Elementor widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls()
	{

		$this->start_controls_section(
			'layout_section',
			[
				'label' => __('Layout', 'swiftcart-core'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout_type',
			[
				'label' => __('Select Layout', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'default' => 'layout_one',
				'options' => [
					'layout_one' => __('Property gallery', 'swiftcart-core'),
					'layout_two' => __('Property Info List', 'swiftcart-core'),
					'layout_three' => __('Property Attachment', 'swiftcart-core'),
					'layout_four' => __('Property Location', 'swiftcart-core'),
					'layout_five' => __('Property Design', 'swiftcart-core'),
					'layout_six' => __('Property Video', 'swiftcart-core'),
				]
			]
		);

		$this->end_controls_section();

		include  swiftcart_get_elementor_option('property-details-one-option.php');
		include  swiftcart_get_elementor_option('property-details-two-option.php');
		include  swiftcart_get_elementor_option('property-details-three-option.php');
		include  swiftcart_get_elementor_option('property-details-four-option.php');
		include  swiftcart_get_elementor_option('property-details-five-option.php');
		include  swiftcart_get_elementor_option('property-details-six-option.php');



		//General style
		$this->start_controls_section(
			'general_style',
			[
				'label' => esc_html__('Section Header Style', 'swiftcart-core'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				'condition' => [
					'layout_type' => ['layout_one', 'layout_two']
				]
			]
		);

		swiftcart_core_elementor_general_style_options($this, 'Title', '{{WRAPPER}} .section-title h2', ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_five']);
		swiftcart_core_elementor_general_style_options($this, 'Sub Title', '{{WRAPPER}} .section-title h6', ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_five']);

		$this->end_controls_section();

		//post style
		$this->start_controls_section(
			'post_style',
			[
				'label' => esc_html__('Style', 'swiftcart-core'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		swiftcart_core_elementor_link_style_options($this, 'Title', '{{WRAPPER}} .single-product-wrap .product-details-inner h4 a', '{{WRAPPER}} .single-product-wrap .product-details-inner h4 a:hover', ['layout_one', 'layout_three', 'layout_four']);

		$this->end_controls_section();
	}

	/**
	 * Render Elementor widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render()
	{
		$settings = $this->get_settings_for_display();


		include swiftcart_get_template('property-details.php');
	}
}

Plugin::instance()->widgets_manager->register(new Swiftcart_Property_Details_Widget());
