<?php

/**
 * Elementor Widget
 * @package SWIFTCART
 * @since 1.0.0
 */

namespace Elementor;

class Swiftcart_Skill_Widget extends Widget_Base
{

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name()
	{
		return 'swiftcart-Skill-widget';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title()
	{
		return esc_html__('Skill', 'swiftcart-core');
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon()
	{
		return 'eicon-product-info';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories()
	{
		return ['swiftcart_widgets'];
	}

	/**
	 * Register Elementor widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls()
	{

		$this->start_controls_section(
			'layout_section',
			[
				'label' => esc_html__('Layout', 'swiftcart-core'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout_type',
			[
				'label' => esc_html__('Select Layout', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'default' => 'layout_one',
				'options' => [
					'layout_one' => esc_html__('Layout One', 'swiftcart-core'),
					// 'layout_two' => esc_html__('Layout Two', 'swiftcart-core'),
					// 'layout_three' => esc_html__('Layout Three', 'swiftcart-core'),
				]
			]
		);

		$this->end_controls_section();

		/*
		* content
		*/
		$this->start_controls_section(
			'content',
			[
				'label' => esc_html__('Content', 'swiftcart-core'),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'title',
			[
				'label' => esc_html__('Title', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__('Add Title', 'swiftcart-core'),
				'default' =>  esc_html__('Add Title', 'swiftcart-core'),

			]
		);

		$this->add_control(
			'summary',
			[
				'label' => esc_html__('Summary', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__('Summary', 'swiftcart-core'),
				'default' => esc_html__('Summary', 'swiftcart-core'),
			]
		);
		$this->add_control(
			'video_url',
			[
				'label' => esc_html__('Video URL', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'placeholder' => esc_html__('Video URL', 'swiftcart-core'),
				'default' => esc_html__('https://www.youtube.com/watch?v=o_MjdUtSL7g', 'swiftcart-core'),
			]
		);
		$this->add_control(
			'video_title',
			[
				'label' => esc_html__('Video Text', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => esc_html__('Video Text', 'swiftcart-core'),
				'placeholder' => esc_html__('Video Text', 'swiftcart-core'),
			]
		);

		$skill = new \Elementor\Repeater();


		$skill->add_control(
			'name',
			[
				'label' => esc_html__('Skill Name', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__('Add Skill Name', 'swiftcart-core'),
				'default' => esc_html__('Web development', 'swiftcart-core')
			]
		);

		$skill->add_control(
			'percentage',
			[
				'label' => esc_html__('Percentage', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'placeholder' => esc_html__('Add Percentage', 'swiftcart-core'),
				'default' => 75
			]
		);

		$this->add_control(
			'skill',
			[
				'label' => esc_html__('Skill', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'prevent_empty' => false,
				'fields' => $skill->get_controls(),
				'title_field' => '{{{ name }}}',
			]
		);


		$this->end_controls_section();

		//images
		$this->start_controls_section(
			'layout_one_images',
			[
				'label' => __('Image', 'swiftcart-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'img_one',
			[
				'label' => __('Image', 'swiftcart-addon'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->end_controls_section();

		//General style
		$this->start_controls_section(
			'general_style',
			[
				'label' => esc_html__('Style Options', 'swiftcart-core'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		swiftcart_core_elementor_general_style_options($this, 'Title', '{{WRAPPER}} .section-title h2', ['layout_one', 'layout_two', 'layout_three']);

		swiftcart_core_elementor_general_style_options($this, 'Video Title', '{{WRAPPER}} .skill-one_image-box .play-button .text', ['layout_one', 'layout_two', 'layout_three']);

		swiftcart_core_elementor_general_style_options($this, 'Summary', '{{WRAPPER}} .section-title p', ['layout_one', 'layout_two', 'layout_three']);

		swiftcart_core_elementor_general_style_options($this, 'Skill Name', '{{WRAPPER}} .skill-item.style-one h5', ['layout_one', 'layout_two', 'layout_three']);

		swiftcart_core_elementor_button_style_options($this, 'Button', '{{WRAPPER}} .skill-one_image-box .play-button .video-popup', '{{WRAPPER}} .skill-one_image-box .play-button .video-popup:hover', ['layout_one', 'layout_three']);

		$this->end_controls_section();
	}

	/**
	 * Render Elementor widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render()
	{
		$settings = $this->get_settings_for_display();
		include swiftcart_get_template('skill-one.php');
		// include swiftcart_get_template('skill-two.php');
		// include swiftcart_get_template('skill-three.php');
	}
}

Plugin::instance()->widgets_manager->register(new Swiftcart_Skill_Widget());
