<?php

/**
 * Elementor Widget
 * @package SWIFTCART
 * @since 1.0.0
 */

namespace Elementor;

class Swiftcart_Tab_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name()
    {
        return 'swiftcart-tab-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title()
    {
        return esc_html__('Tab', 'swiftcart-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon()
    {
        return 'eicon-product-info';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @since 1.0.0
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories()
    {
        return ['swiftcart_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function _register_controls()
    {

        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'swiftcart-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'swiftcart-core'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'swiftcart-core'),
                    'layout_two' => __('Layout Two', 'swiftcart-core'),
                ]
            ]
        );

        $this->end_controls_section();

        include  swiftcart_get_elementor_option('tab-one-option.php');
        include  swiftcart_get_elementor_option('tab-two-option.php');


        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Style Options', 'swiftcart-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        swiftcart_core_elementor_general_style_options($this, 'Sec Sub Title', '{{WRAPPER}} .sub-title.style-one,.home-two .sub-title, {{WRAPPER}} .faq-page-area-two .section-title h2', ['layout_one', 'layout_two', 'layout_three']);

        swiftcart_core_elementor_general_style_options($this, 'Sec Title', '{{WRAPPER}} .section-title h2,.home-two .section-title h2, .home-three span.sub-title', ['layout_one', 'layout_two', 'layout_three']);

        swiftcart_core_elementor_general_style_options($this, 'Sec Summary', '.home-two .section-title p, {{WRAPPER}} .faq-page-area-two .section-title p, {{WRAPPER}} .faq-page-area .section-title p', ['layout_one', 'layout_three']);

        swiftcart_core_elementor_button_style_options($this, 'Tab Button', '{{WRAPPER}} .theme-tabs.style-one .nav-link', '{{WRAPPER}} .theme-tabs.style-one .nav-link:hover', ['layout_one', 'layout_two']);

        swiftcart_core_elementor_button_style_options($this, 'Tab Button Active', '{{WRAPPER}} .theme-tabs.style-one .nav-link.active', '{{WRAPPER}} .theme-tabs.style-one .nav-link.active:hover', ['layout_one', 'layout_two']);

        swiftcart_core_elementor_general_style_options($this, 'Title', '{{WRAPPER}} .ac-tab-one_content-box h5', ['layout_one']);
        swiftcart_core_elementor_general_style_options($this, 'Summary', '{{WRAPPER}} .ac-tab-one_content-box p', ['layout_one']);
        swiftcart_core_elementor_general_style_options($this, 'Name', '{{WRAPPER}} .ac-tab-one_content-box .author-thumb-item .content h6', ['layout_one']);
        swiftcart_core_elementor_general_style_options($this, 'Bio', '{{WRAPPER}} .ac-tab-one_content-box .author-thumb-item .content span.position', ['layout_one']);

        swiftcart_core_elementor_button_style_options($this, 'Button', '{{WRAPPER}} .theme-btn.style-one', '{{WRAPPER}} .theme-btn.style-one:hover', ['layout_one']);

        $this->end_controls_section();
    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include swiftcart_get_template('tab-one.php');
        include swiftcart_get_template('tab-two.php');
    }
}

Plugin::instance()->widgets_manager->register(new Swiftcart_Tab_Widget());
