<?php

/**
 * Elementor Widget
 * @package SWIFTCART
 * @since 1.0.0
 */

namespace Elementor;

class Swiftcart_Team_Widget extends Widget_Base
{

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name()
	{
		return 'swiftcart-team-widget';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title()
	{
		return esc_html__('Team', 'swiftcart-core');
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon()
	{
		return 'eicon-product-info';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories()
	{
		return ['swiftcart_widgets'];
	}

	/**
	 * Register Elementor widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls()
	{

		$this->start_controls_section(
			'layout_section',
			[
				'label' => __('Layout', 'swiftcart-core'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout_type',
			[
				'label' => __('Select Layout', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'default' => 'layout_one',
				'options' => [
					'layout_one' => __('Layout One', 'swiftcart-core'),
					// 'layout_two' => __('Layout Two', 'swiftcart-core'),
					// 'layout_three' => __('Layout Three', 'swiftcart-core'),
					// 'layout_four' => __('Layout Four', 'swiftcart-core'),
					// 'layout_five' => __('Layout Five', 'swiftcart-core'),
				]
			]
		);

		$this->end_controls_section();

		include  swiftcart_get_elementor_option('team-one-option.php');

		//General style
		$this->start_controls_section(
			'general_style',
			[
				'label' => esc_html__('Style Options', 'swiftcart-core'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		swiftcart_core_elementor_general_style_options($this, 'Section Title', '{{WRAPPER}} .section-title h2', ['layout_two', 'layout_three', 'layout_four', 'layout_five']);
		swiftcart_core_elementor_general_style_options($this, 'Section Sub Title', '{{WRAPPER}} .section-title h6', ['layout_two', 'layout_three', 'layout_four', 'layout_five']);

		swiftcart_core_elementor_general_style_options($this, 'Name', '{{WRAPPER}} .team-item.style-one .member-info .content h4', ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_five']);

		swiftcart_core_elementor_general_style_options($this, 'Bio', '{{WRAPPER}} .team-item.style-one .member-info .position', ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_five']);

		swiftcart_core_elementor_button_style_options($this, 'Socail Icon', '{{WRAPPER}} .team-item.style-one .member-info .share-button ul.social-link li a', '{{WRAPPER}} ..team-item.style-one .member-info .share-button ul.social-link li a:hover', ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_five']);


		$this->end_controls_section();
	}

	/**
	 * Render Elementor widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render()
	{
		$settings = $this->get_settings_for_display();

		include swiftcart_get_template('team-one.php');
		// include swiftcart_get_template('team-two.php');
		// include swiftcart_get_template('team-three.php');
		// include swiftcart_get_template('team-four.php');
		// include swiftcart_get_template('team-five.php');
	}
}

Plugin::instance()->widgets_manager->register(new Swiftcart_Team_Widget());
