<?php

/**
 * Elementor Widget
 * @package SWIFTCART
 * @since 1.0.0
 */

namespace Elementor;

class Swiftcart_Testimonial_Widget extends Widget_Base
{

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name()
	{
		return 'swiftcart-testimonial-widget';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title()
	{
		return esc_html__('Testimonial', 'swiftcart-core');
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon()
	{
		return 'eicon-product-info';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories()
	{
		return ['swiftcart_widgets'];
	}

	/**
	 * Register Elementor widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls()
	{

		$this->start_controls_section(
			'layout_section',
			[
				'label' => __('Layout', 'swiftcart-core'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout_type',
			[
				'label' => __('Select Layout', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'default' => 'layout_one',
				'options' => [
					'layout_one' => __('Layout One', 'swiftcart-core'),
					'layout_two' => __('Layout Two', 'swiftcart-core'),
					'layout_three' => __('Layout Three', 'swiftcart-core'),
				]
			]
		);

		$this->end_controls_section();



		include  swiftcart_get_elementor_option('testimonail-one-option.php'); // also layout two
		include  swiftcart_get_elementor_option('testimonail-three-option.php');



		//General style
		$this->start_controls_section(
			'general_style',
			[
				'label' => esc_html__('Style Options', 'swiftcart-core'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		swiftcart_core_elementor_general_style_options($this, 'Testimonial Subtitle', '{{WRAPPER}} .sub-title.style-one,{{WRAPPER}} .sub-title', ['layout_one', 'layout_two', 'layout_three']);
		swiftcart_core_elementor_general_style_options($this, 'Testimonial Title', '{{WRAPPER}} .section-title h2', ['layout_one', 'layout_two', 'layout_three']);
		swiftcart_core_elementor_general_style_options($this, 'Testimonial Summary', '{{WRAPPER}} .section-title p', ['layout_one', 'layout_two', 'layout_three']);


		swiftcart_core_elementor_general_style_options($this, 'Testimonial Name', '{{WRAPPER}} .testimonial-item.style-one .testimonial-content .author-thumb-item .content h6, {{WRAPPER}} .testimonial-item.style-two .testimonial-content .author-thumb-item .content h6, {{WRAPPER}} .testimonial-item-three .name', ['layout_one', 'layout_two', 'layout_three']);

		swiftcart_core_elementor_general_style_options($this, 'Testimonial Bio', '{{WRAPPER}} .testimonial-item.style-one .testimonial-content .author-thumb-item .content span.position,{{WRAPPER}} .testimonial-item.style-two .testimonial-content .author-thumb-item .content span.position', ['layout_one', 'layout_two', 'layout_three']);

		swiftcart_core_elementor_general_style_options($this, 'Testimonial Content', '{{WRAPPER}} .testimonial-item.style-one .testimonial-content p, {{WRAPPER}} .testimonial-item.style-two .testimonial-content p, {{WRAPPER}} .testimonial-item-three .text', ['layout_one', 'layout_two', 'layout_three']);

		swiftcart_core_elementor_general_style_options($this, 'Testimonial Rating', '{{WRAPPER}} .ratings i', ['layout_two']);


		$this->end_controls_section();
	}

	/**
	 * Render Elementor widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render()
	{
		$settings = $this->get_settings_for_display();
		include swiftcart_get_template('testimonial-one.php');
		include swiftcart_get_template('testimonial-two.php');
		include swiftcart_get_template('testimonial-three.php');
	}
}

Plugin::instance()->widgets_manager->register(new Swiftcart_Testimonial_Widget());
