<?php

/**
 * Elementor Widget
 * @package SWIFTCART
 * @since 1.0.0
 */

namespace Elementor;

class Swiftcart_Video_Widget extends Widget_Base
{

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name()
	{
		return 'swiftcart-video-widget';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title()
	{
		return esc_html__('Video', 'swiftcart-core');
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon()
	{
		return 'eicon-product-info';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories()
	{
		return ['swiftcart_widgets'];
	}

	/**
	 * Register Elementor widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls()
	{

		$this->start_controls_section(
			'layout_section',
			[
				'label' => __('Layout', 'swiftcart-core'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout_type',
			[
				'label' => __('Select Layout', 'swiftcart-core'),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'default' => 'layout_one',
				'options' => [
					'layout_one' => __('Layout One', 'swiftcart-core'),
					'layout_two' => __('Layout Two', 'swiftcart-core'),
					'layout_three' => __('Layout Three', 'swiftcart-core'),
					'layout_four' => __('Layout Four', 'swiftcart-core'),
				]
			]
		);

		$this->end_controls_section();

		include  swiftcart_get_elementor_option('video-one-option.php');
		include  swiftcart_get_elementor_option('video-two-option.php');
		include  swiftcart_get_elementor_option('video-three-option.php');
		include  swiftcart_get_elementor_option('video-four-option.php');

		//General style
		$this->start_controls_section(
			'general_style',
			[
				'label' => esc_html__('Style Options', 'swiftcart-core'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		swiftcart_core_elementor_general_style_options($this, 'Sub Title', '{{WRAPPER}} .text-white .sub-title.style-one, .home-three span.sub-title', ['layout_one', 'layout_two', 'layout_three', 'layout_four']);
		swiftcart_core_elementor_general_style_options($this, 'Sec Title', '{{WRAPPER}} .section-title h2', ['layout_one', 'layout_two', 'layout_three', 'layout_four']);
		swiftcart_core_elementor_general_style_options($this, 'Sec Summary', '{{WRAPPER}} .intro-wrapper .section-content-box p, .section-title p,{{WRAPPER}} .circle-list.style-one li', ['layout_one', 'layout_two', 'layout_three', 'layout_four']);

		swiftcart_core_elementor_button_style_options($this, 'Video Icon', '{{WRAPPER}} .intro-wrapper .section-content-box p, .avatar-item.style-one .avatar-img .hover-overlay .video-popup, .video-two_image-box .video-popup', '{{WRAPPER}} .intro-wrapper .section-content-box p:hover, .avatar-item.style-one .avatar-img .hover-overlay .video-popup:hover, .video-two_image-box .video-popup:hover', ['layout_one', 'layout_two', 'layout_three']);

		swiftcart_core_elementor_button_style_options($this, 'Button', '{{WRAPPER}} .theme-btn.style-one,{{WRAPPER}} .features-image-card .content .theme-btn.style-two', '{{WRAPPER}} .theme-btn.style-one:hover, {{WRAPPER}} .features-image-card .content .theme-btn.style-two:hover', ['layout_three', 'layout_four']);

		swiftcart_core_elementor_link_style_options($this, 'Title', '{{WRAPPER}} .features-image-card .content h4 a', '{{WRAPPER}} .features-image-card .content h4 a:hover', ['layout_four']);

		swiftcart_core_elementor_general_style_options($this, 'Summary', '{{WRAPPER}} .features-image-card .content p', ['layout_four']);

		swiftcart_core_elementor_button_style_options($this, 'Tab Button', '{{WRAPPER}} .voiceovers-tabs-wrap .theme-tabs.style-two .nav-link', '{{WRAPPER}} .voiceovers-tabs-wrap .theme-tabs.style-two .nav-link:hover', ['layout_three']);
		swiftcart_core_elementor_button_style_options($this, 'Tab Button Active', '{{WRAPPER}} .theme-tabs.style-two .nav-link.active', '{{WRAPPER}} .theme-tabs.style-two .nav-link.active:hover', ['layout_three']);

		$this->end_controls_section();
	}

	/**
	 * Render Elementor widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render()
	{
		$settings = $this->get_settings_for_display();
		include swiftcart_get_template('video-one.php');
		include swiftcart_get_template('video-two.php');
		include swiftcart_get_template('video-three.php');
		include swiftcart_get_template('video-four.php');
	}
}

Plugin::instance()->widgets_manager->register(new Swiftcart_Video_Widget());
